#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Most;
use Test::More;
use Test::Deep;
use Test::Exception;
use Test::MockObject::Extends;
use Test::Partner::DB::Mock;
use Test::Partner2::Mock;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        $app->{'__CURRENT_USER_RIGHTS__'} = {};

        $app->api_http_gozora;
        $app->{'api_http_gozora'} = Test::MockObject::Extends->new($app->{'api_http_gozora'});
        $app->api_http_gozora->mock('get_page_inf', sub {{body_length_bytes => 1}});

        #Добавление  сайтов

        eval {$app->site->add(domain => 'test.com')};
        is(ref($@), 'Exception::Denied', 'Exception is thrown.');

        change_cur_user($app, 'mocked-yan-partner');

        throws_ok(
            sub {$app->site->add()},
            'Exception::Validator::Errors',
            'trying to add site w/o "domain" argument; Exception is thrown.'
        );

        my $domain = '1.c';
        throws_ok(
            sub {$app->site->add(domain => $domain);},
            'Exception::Validator::Errors',
            "trying to add [$domain] as domain; len < len_min; Exception is thrown."
        );

        $domain = 't' x 255 . '.org';
        throws_ok(
            sub {$app->site->add(domain => $domain);},
            'Exception::Validator::Errors',
            "trying to add [$domain] as domain; len > len_max; Exception is thrown."
        );

        $domain = 'test-domain.yandex.ru';
        throws_ok(
            sub {$app->site->add(domain => $domain);},
            'Exception::Validator::Errors',
            "trying to add [$domain] as domain; Exception is thrown."
        );

        $domain = 'test.com';
        $app->site->add(domain => $domain);

        $domain = 'www.test.com';
        throws_ok(
            sub {$app->site->add(domain => $domain)},
            'Exception::Validator::Errors',
            "trying to add [$domain] as domain; Exception is thrown."
        );
    }
);
