use qbit;

use Test::Partner2::Simple;
use Test::More tests => 4;
use Test::Partner::Utils qw(mock_curdate);

use File::Temp qw(tempfile tempdir);
use File::Slurp qw(read_file write_file);

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2018-02-13 16:54:18');
        my $method   = 'fake_method';
        my $date     = curdate(oformat => 'db');
        my $tmp_path = (tempfile(OPEN => 0))[1];
        write_file($tmp_path, "mocked_data\n#END\n");
        my $fake_stat_cache_dir = tempdir() . '/';
        my $hostname            = 'fake_hostname';

        $app->stat_download_data->set_option(local_stat_cache_dir => $fake_stat_cache_dir);
        $app->set_option(hostname => $hostname);

        $app->stat_download_data->cache_http_data(
            method            => $method,
            date              => $date,
            path              => $tmp_path,
            remove_end_marker => "#END\n",
        );

        my $data = $app->stat_download_data->get_all(
            fields => [qw(method stat_date hostname checksum update_time filename)],
            filter => {method => $method, stat_date => $date},
        );

        is_deeply(
            $data,
            [
                {
                    'update_time' => '2018-02-13 16:54:18',
                    'checksum'    => '3492489193',
                    'filename'    => "${method}__${date}__2018-02-13_16-54-18.dump",
                    'stat_date'   => $date,
                    'method'      => $method,
                    'hostname'    => $hostname
                },
            ],
            'table record'
        );

        is_deeply(read_file("$fake_stat_cache_dir$data->[0]{filename}"), "mocked_data\n", 'file contents');
    },
    fill_databases => 0,
);
