use qbit;

my %to_be_deleted = (
    'nginx/stat_cache/get_publisher_stat_2017-06-02_2017-06-04_12-00-00.dump' => 1,
    'nginx/stat_cache/get_publisher_stat_2017-06-03_2017-06-04_12-00-00.dump' => 1,
    'nginx/stat_cache/get_publisher_stat_2017-06-03_2017-06-04_14-00-00.dump' => 1,
);

{

    package Application::Model::StatDownloadData;
    use subs qw(unlink);
    use Test::More;

    sub unlink {
        my ($filename) = @_;
        delete($to_be_deleted{$filename}) or fail("Unexpected file $filename");
        return 1;
    }

}

use Test::Partner2::Simple;
use Test::More tests => 5;

use Data::Dumper;

my $expected_before_deletion = [
    {
        'sync'      => '1',
        'stat_date' => '2017-06-02',
        'method'    => 'get_publisher_stat',
        'hostname'  => 'pi-rtb01e.yandex.ru'
    },
    {
        'sync'      => '0',
        'stat_date' => '2017-06-02',
        'method'    => 'get_publisher_stat',
        'hostname'  => 'pi-rtb01f.yandex.ru'
    },
    {
        'sync'      => '1',
        'stat_date' => '2017-06-03',
        'method'    => 'get_publisher_stat',
        'hostname'  => 'pi-rtb01e.yandex.ru'
    },
    {
        'sync'      => '0',
        'stat_date' => '2017-06-03',
        'method'    => 'get_publisher_stat',
        'hostname'  => 'pi-rtb01e.yandex.ru'
    }
];

my $expected_after_deletion = [
    {
        'sync'      => '0',
        'stat_date' => '2017-06-02',
        'method'    => 'get_publisher_stat',
        'hostname'  => 'pi-rtb01e.yandex.ru'
    },
    {
        'sync'      => '0',
        'stat_date' => '2017-06-02',
        'method'    => 'get_publisher_stat',
        'hostname'  => 'pi-rtb01f.yandex.ru'
    },
    {
        'sync'      => '0',
        'stat_date' => '2017-06-03',
        'method'    => 'get_publisher_stat',
        'hostname'  => 'pi-rtb01e.yandex.ru'
    }
];

run_tests(
    sub {
        my ($app) = @_;

        my $filter = [update_time => '>=' => '2017-06-04 12:00:00'];
        $app->set_option(hostname => 'pi-rtb01e.yandex.ru');

        my $before_deletion = $app->stat_download_data->get_all(filter => $filter);

        is_deeply($before_deletion, $expected_before_deletion, 'before');

        $app->stat_download_data->delete_cached_data($filter);

        my $after_deletion = $app->stat_download_data->get_all(filter => $filter);

        is_deeply($after_deletion, $expected_after_deletion, 'after');

        ok(keys(%to_be_deleted) == 0, 'files unlinked');
    },
);
