use qbit;

use File::Temp qw(tempdir);
use Test::More tests => 5;

my $fake_stat_cache_dir = tempdir(CLEANUP => 1) . '/';

{

    package Application::Model::StatDownloadData;
    use subs qw(system);
    use Test::More;

    sub system {
        my (@args) = @_;

        if ($args[3] eq '--include=get_publisher_stat_2017-06-03_2017-06-04_14-00-00.dump') {
            `touch $fake_stat_cache_dir/get_publisher_stat_2017-06-03_2017-06-04_14-00-00.dump`;
        } else {
            fail("Got unexpected file $args[3]");
        }

        splice @args, 3, 1;

        is_deeply(
            \@args,
            ['rsync', '--dirs', '--delete', '--exclude=*', 'pi-rtb01e.yandex.ru::stat/', $fake_stat_cache_dir],
            'rsync invocation line'
        );
        return 0;
    }

}

use Test::Partner2::Simple;

my $hostname          = 'pi-rtb01f.yandex.ru';
my $expected_unsynced = [
    {
        method      => 'get_publisher_stat',
        stat_date   => '2017-06-03',
        update_time => '2017-06-04 14:00:00',
        hostname    => 'pi-rtb01e.yandex.ru'
    },
];

run_tests(
    sub {
        my ($app) = @_;

        $app->stat_download_data->set_option(local_stat_cache_dir => $fake_stat_cache_dir);
        $app->set_option(hostname => $hostname);

        my $unsynced = $app->stat_download_data->get_all(
            fields => [qw(method stat_date update_time hostname)],
            filter => [AND => [[hostname => '<>' => $hostname], [sync => '=' => 0]]]
        );

        is_deeply($unsynced, $expected_unsynced, 'unsynced file');

        $app->stat_download_data->pull_changes_from_other_host();

        my $downloaded = $app->stat_download_data->get_all(filter => $expected_unsynced->[0], fields => [qw(sync)]);
        is_deeply($downloaded, [{sync => 1}], 'downloaded');
    },
);
