#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Differences;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my %data;
        $data{'00_init'} = $app->tns_dict_article->get_real_article_tree;

        $app->partner_db->tns_dict_article->add(
            {
                sid  => 42,
                lev  => 2,
                name => {
                    en => 'new article',
                    ru => 'новая тема',
                },
            }
        );

        $data{'01_insert'} = $app->tns_dict_article->get_real_article_tree;

        $app->kv_store->set('update_tns_dict_article', '2018-12-31 00:00:00');

        $data{'02_renew'} = $app->tns_dict_article->get_real_article_tree;

        my $has = get_test_data_and_update_if_needed('data.json', \%data, blessed => TRUE);
        eq_or_diff(from_json(to_json(\%data, blessed => TRUE)), $has, 'compare data');
    },
    user => 'yndx-developer',
);

package Tree::Simple;

sub TO_JSON {
    my $self = shift;
    return +{
        data  => $self->{_node},
        child => $self->{_children},
    };
}
