use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use qbit;

use utf8;
use Test::More tests => 5;
use Test::Differences;
use Test::Exception;

my $USER_LOGIN   = 'mocked-yan-partner';
my $FEATURE_NAME = 'users_view_all';

run_tests(
    sub {
        my ($app) = @_;

        {    # Add some test feature to config
            no warnings qw(once);
            $Application::Model::Users::Features::ALL_FEATURES{$FEATURE_NAME} = {
                name   => gettext('users_view'),
                rights => [qw(users_view_all)]
            };
        }

        lives_ok {
            $app->user_features->get_all_features();
        }
        'Normal getting of all features before calling add feature';

        lives_ok {
            $app->user_features->add($app->cur_user->get_cur_user_id(), $FEATURE_NAME);
        }
        'Normal calling add feature';

        # This is fixed by PI-18482
        lives_ok {
            $app->user_features->get_all_features();
        }
        'No error while getting of all features again after';
    },
    init => [
        qw(
          user_features
          users
          )
    ],
    user => $USER_LOGIN,
);
