use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Partner::Utils;
use Test::Differences;
use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my @logins = (
            {
                id    => 1009,    #'mocked-yan-partner'
                roles => [9],
            },
            {
                id    => 1009,    #'mocked-yan-partner'
                roles => [],
            },
            {
                id    => 1028,    # 'mocked-indoor-partner'
                roles => [40],
            },
            {
                id => 1009,       #'mocked-yan-partner'
            },
            {
                id => [
                    1009,         # 'mocked-yan-partner'
                    1028,         # 'mocked-indoor-partner'
                    1010,         # 'mocked-video-partner'
                ]
            },
        );

        my @result;
        foreach my $login (@logins) {
            my @r = sort $app->user_features->get_user_rights($login->{id}, $login->{roles});
            push @result, [$login, \@r];
        }
        my $has_data = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(from_json(to_json(\@result)), $has_data, 'checks');
    },
    user => 'yndx-developer',
);
