use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use qbit;

use utf8;
use Test::More;
use Test::Exception;
use Test::Deep qw(cmp_bag);

my $USER_LOGIN = 'mocked-yan-manager';

run_tests(
    sub {
        my ($app) = @_;

        {
            no warnings qw(redefine once);
            %Application::Model::Users::Features::ALL_FEATURES = (
                users_view => {
                    name   => gettext('users_view'),
                    rights => [qw(users_view)]
                },
                users_view_all => {
                    name   => gettext('users_view'),
                    rights => [qw(users_view_all)]
                },
                users_edit_all => {
                    name   => gettext('users_view'),
                    rights => [qw(users_edit_all)]
                },
                users_all => {
                    name   => gettext('users_view'),
                    rights => [qw(users_view_all users_edit_all)]
                },
            );
        }

        $app->users->edit($app->cur_user->get_cur_user_id(), features => []);

        check_add_feature($app);

        check_add_duplicate_feature($app);

        check_add_bad_feature($app);

        check_delete($app);

        check_replace_multi($app);

    },
    init => ['users'],
    user => $USER_LOGIN,
);

sub check_add_feature {
    my ($app) = @_;

    $app->user_features->add($app->cur_user->get_cur_user_id(), 'users_view');
    $app->user_features->add($app->cur_user->get_cur_user_id(), 'users_view_all');

    cmp_bag(
        $app->user_features->get_all(fields => [qw(feature)], filter => {user_id => $app->cur_user->get_cur_user_id()}),
        [{feature => "users_view"}, {feature => "users_view_all"}],
        'add feature works',
    );
}

sub check_add_duplicate_feature {
    my ($app) = @_;

    throws_ok {
        $app->user_features->add($app->cur_user->get_cur_user_id(), 'users_view');
    }
    qr/Users feature "users_view" already added/, 'user_features->add() dies when trying to add the same feature';
}

sub check_add_bad_feature {
    my ($app) = @_;

    throws_ok {
        $app->user_features->add($app->cur_user->get_cur_user_id(), 'users_something');
    }
    qr/Users feature "users_something" does not exists/, 'user_features->add() dies when trying to add bad feature';
}

sub check_delete {
    my ($app) = @_;

    $app->user_features->delete($app->cur_user->get_cur_user_id(), 'users_view_all');

    cmp_bag(
        $app->user_features->get_all(fields => [qw(feature)], filter => {user_id => $app->cur_user->get_cur_user_id()}),
        [{feature => "users_view"}],
        'delete features works',
    );
}

sub check_replace_multi {
    my ($app) = @_;

    $app->user_features->replace_multi($app->cur_user->get_cur_user_id(), ['users_view_all', 'users_edit_all']);

    cmp_bag(
        $app->user_features->get_all(fields => [qw(feature)], filter => {user_id => $app->cur_user->get_cur_user_id()}),
        [{feature => "users_view_all"}, {feature => "users_edit_all"}],
        'replace_multi features works',
    );
}
