use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use utf8;
use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        my $data = $app->user_global_excluded_domains->get_all();
        is_deeply(
            $data,
            [
                {
                    domain  => 'design.ru',
                    user_id => 1009,
                },
                {
                    domain  => 'rambler.ru',
                    user_id => 1009,
                },
                {
                    domain  => 'сайт.рф',
                    user_id => 1009,
                },
                {
                    domain  => 'twitter.com',
                    user_id => 1011,
                },
            ],
        );
    },
    user => 'yndx-developer'
);
