use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use utf8;
use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        is_deeply($app->user_global_excluded_domains->get_all_domains($app->cur_user->get_cur_user_id()),
            [qw(design.ru rambler.ru сайт.рф)]);

        $app->user_global_excluded_domains->delete($app->cur_user->get_cur_user_id(), 'design.ru');
        is_deeply($app->user_global_excluded_domains->get_all_domains($app->cur_user->get_cur_user_id()),
            [qw(rambler.ru сайт.рф)]);

        $app->user_global_excluded_domains->delete($app->cur_user->get_cur_user_id(), 'rambler.ru');
        $app->user_global_excluded_domains->delete($app->cur_user->get_cur_user_id(), 'сайт.рф');
        is_deeply($app->user_global_excluded_domains->get_all_domains($app->cur_user->get_cur_user_id()), []);
    },
    user => 'mocked-yan-partner',
);
