use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use utf8;
use Test::More;
use Test::Exception;

sub check_initial_db_state {
    my ($app) = @_;

    is_deeply(
        $app->user_global_excluded_domains->get_all_domains($app->cur_user->get_cur_user_id()),
        ['design.ru', 'rambler.ru', 'сайт.рф'],
        'Correct initial database state',
    );

}

sub check_replace_multi_with_correct_domains {
    my ($app) = @_;

    is(
        $app->user_global_excluded_domains->replace_multi($app->cur_user->get_cur_user_id(), 'aaa.ru', 'bbb.io'),
        1, 'user_global_excluded_domains->replace_multi() return 1',
      );

    is_deeply(
        $app->user_global_excluded_domains->get_all_domains($app->cur_user->get_cur_user_id()),
        [qw(aaa.ru bbb.io)], 'Correct database state after replacing with correct domains',
    );
}

sub check_replace_multi_with_incorrect_domains {
    my ($app) = @_;

    throws_ok {
        $app->user_global_excluded_domains->replace_multi($app->cur_user->get_cur_user_id(), '|||', '*.ru');
    }
    qr/Invalid domain: "|||"/,
      'user_global_excluded_domains->replace_multi() dies when trying to add incorrect domains';

    is_deeply(
        $app->user_global_excluded_domains->get_all_domains($app->cur_user->get_cur_user_id()),
        [qw(aaa.ru bbb.io)], 'Got the same database state after trying to replace with incorrect domains',
    );
}

sub check_replace_multi_with_duplicate_domains {
    my ($app) = @_;

    is(
        $app->user_global_excluded_domains->replace_multi(
            $app->cur_user->get_cur_user_id(),
            'aaa.ru', 'bbb.io', 'bbb.io'
        ),
        1,
        'user_global_excluded_domains->replace_multi() return 1',
      );

    is_deeply(
        $app->user_global_excluded_domains->get_all_domains($app->cur_user->get_cur_user_id()),
        [qw(aaa.ru bbb.io)], 'Correct database state after replacing with correct domains',
    );
}

run_tests(
    sub {
        my ($app) = @_;

        $app->set_app_locale('en');

        check_initial_db_state($app);
        check_replace_multi_with_correct_domains($app);
        check_replace_multi_with_incorrect_domains($app);
        check_replace_multi_with_duplicate_domains($app);

    },
    user => 'mocked-yan-partner',
);
