use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        my $data = $app->user_global_excluded_phones->get_all();

        is_deeply(
            $data,
            [
                {
                    phone   => "+7 123",
                    user_id => 1009,
                },
                {
                    phone   => 123,
                    user_id => 1009,
                },
                {
                    phone   => '+7 495 739-70-00',
                    user_id => 1011,
                },
            ],
        );
    },
    user => 'yndx-developer'
);
