use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        is_deeply($app->user_global_excluded_phones->get_all_phones($app->cur_user->get_cur_user_id()),
            ["+7 123", 123]);

        $app->user_global_excluded_phones->delete($app->cur_user->get_cur_user_id(), '+7 123');
        is_deeply($app->user_global_excluded_phones->get_all_phones($app->cur_user->get_cur_user_id()), [123]);

        $app->user_global_excluded_phones->delete($app->cur_user->get_cur_user_id(), '123');
        is_deeply($app->user_global_excluded_phones->get_all_phones($app->cur_user->get_cur_user_id()), []);

    },
    user => 'mocked-yan-partner',
);
