use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use Test::Exception;

sub check_initial_db_state {
    my ($app) = @_;

    is_deeply(
        $app->user_global_excluded_phones->get_all_phones($app->cur_user->get_cur_user_id()),
        ["+7 123", 123,],
        'Correct initial database state',
    );

}

sub check_replace_multi_with_correct_phones {
    my ($app) = @_;

    is(
        $app->user_global_excluded_phones->replace_multi($app->cur_user->get_cur_user_id(), '888', '999'),
        1, 'user_global_excluded_phones->replace_multi() return 1',
      );

    is_deeply(
        $app->user_global_excluded_phones->get_all_phones($app->cur_user->get_cur_user_id()),
        [888, 999,],
        'Correct database state after replacing with correct phones',
    );
}

sub check_replace_multi_with_incorrect_phones {
    my ($app) = @_;

    throws_ok {
        $app->user_global_excluded_phones->replace_multi($app->cur_user->get_cur_user_id(), 'aaa', 'bbb');
    }
    'Exception::Validator::Errors',
      'user_global_excluded_phones->replace_multi() dies when trying to add incorrect phones';

    is_deeply(
        $app->user_global_excluded_phones->get_all_phones($app->cur_user->get_cur_user_id()),
        [888, 999,],
        'Got the same database state after trying to replace with incorrect phones',
    );
}

sub check_replace_multi_with_duplicate_phones {
    my ($app) = @_;

    is(
        $app->user_global_excluded_phones->replace_multi($app->cur_user->get_cur_user_id(), '888', '888', '999'),
        1, 'user_global_excluded_phones->replace_multi() return 1',
      );

    is_deeply(
        $app->user_global_excluded_phones->get_all_phones($app->cur_user->get_cur_user_id()),
        [888, 999,],
        'Correct database state after replacing with correct phones',
    );
}

run_tests(
    sub {
        my ($app) = @_;

        $app->set_app_locale('en');

        check_initial_db_state($app);
        check_replace_multi_with_correct_phones($app);
        check_replace_multi_with_incorrect_phones($app);
        check_replace_multi_with_duplicate_phones($app);

    },
    user => 'mocked-yan-partner',
);
