use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        change_cur_user($app, 'mocked-yan-partner-assistant');

        my $users = $app->users->get_all(fields => [qw(id)], order_by => [qw(id)]);

        cmp_deeply([map {$_->{'id'}} @$users], ['1009', '1016', '1018'], 'check available users');

        $app->partner_db->assistants->add({user_id => 1018, page_id => 801, can_edit => 0});

        $users = $app->users->get_all(fields => [qw(id)], order_by => [qw(id)]);

        cmp_deeply(
            [map {$_->{'id'}} @$users],
            ['1009', '1010', '1016', '1018'],
            'check available users after link to new page'
        );
    },
);
