#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;

use Test::Differences;
use Test::More tests => 2;

run_tests(
    sub {
        my ($app) = @_;

        my $users = $app->users;

        no strict 'refs';
        no warnings 'redefine';

        *{'Application::Model::Documents::get_active_contract'} = sub {
            return {
                Contract => {
                    contract2_id => 24680,
                    external_id  => 'external PI contract',
                },
                Person => {
                    client_id => 111,
                    id        => 111,
                },
            };
        };
        *{'Application::Model::Users::create_contract_adfox_paid_products'} = sub {
            return {
                'client_id' => 111,
                'id'        => 1236739
            };
        };
        *{'Application::Model::API::Yandex::AdFoxGraphQL::set_billing_data'} = sub {
            return TRUE;
        };
        $users->do_action(1038, 'edit', 'adfox_offer', 1);
    },
    init => [qw(users api_adfox_graphql)],
    user => 'mocked-yan-partner-with-paid-offer',
);
