#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;

use Test::More;
use Test::Partner2::Mock;
use Test::Partner::Utils;

run_tests(
    \&main_test,
    init => ['users', 'api_http_banner_storage'],
    user => 'mocked-yan-partner',
);

sub main_test {
    my ($app) = @_;

    mock_subs(
        {
            'Application::Model::API::Yandex::BannerStorage::HTTP::call' => sub {
                return;
              }
        }
    );

    my $cur_user   = $app->get_option('cur_user');
    my $tmp_rights = $app->add_tmp_rights(qw(do_user_action_request_create_in_banner_store));

    $app->users->do_action($cur_user->{'id'}, 'request_create_in_banner_store',);

    $app->users->do_action(
        $cur_user->{'id'},
        'created_partner_in_banner_store',
        password     => '12345',
        company_name => 'test',
    );

    my $sql = "select `opts`->>'\$.password' as pass
from `users_action_log`
where `elem_id`=$cur_user->{'id'}
and action='created_partner_in_banner_store'";
    my $rows = $app->partner_db->_get_all($sql);

    ok $rows->[0]{pass} eq '?', 'no pass';
}
