#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;

use Test::Differences;
use Test::Exception;
use Test::More;
use Test::Partner::Utils qw(request_to_intapi);

my $file_name    = 'test_data.json';
my $path_to_data = $0;
$path_to_data =~ s/\.t$/\/$file_name/;

my %mocked_adfox_users = (
    mocked_adfox_user_with_incorrect_psw => to_json(
        {
            data   => {AdfoxInternal => {billingClientInfo => undef,},},
            errors => [
                {
                    category => 'access',
                    code     => 1,
                    message  => 'Password for user is not correct',
                }
            ],
        },
    ),
    mocked_adfox_user_with_invalid_json_answer => 'invalid json',
    mocked_adfox_user_with_incomplete_answer   => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 0,
                        billingContractId        => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    mocked_adfox_user_not_white_list => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 7997862,
                        billingContractId        => 237044,
                        hasOtherAccounts         => JSON::XS::false,
                        hasPaidServices          => JSON::XS::false,
                        piAccounts               => [],
                        complexPiLinks           => JSON::XS::false,
                        inWhitelist              => JSON::XS::false,
                        needCloseContract        => JSON::XS::true,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    mocked_adfox_user_without_client_id => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 0,
                        billingContractId        => 0,
                        hasOtherAccounts         => JSON::XS::false,
                        hasPaidServices          => JSON::XS::false,
                        piAccounts               => [],
                        complexPiLinks           => JSON::XS::false,
                        inWhitelist              => JSON::XS::true,
                        needCloseContract        => JSON::XS::true,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    mocked_adfox_user_without_contract => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 7997862,
                        billingContractId        => 0,
                        hasOtherAccounts         => JSON::XS::false,
                        hasPaidServices          => JSON::XS::false,
                        piAccounts               => [],
                        complexPiLinks           => JSON::XS::false,
                        inWhitelist              => JSON::XS::true,
                        needCloseContract        => JSON::XS::true,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    mocked_adfox_user_with_shared_contract => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 7997862,
                        billingContractId        => 237044,
                        hasOtherAccounts         => JSON::XS::true,
                        hasPaidServices          => JSON::XS::false,
                        piAccounts               => [],
                        complexPiLinks           => JSON::XS::false,
                        inWhitelist              => JSON::XS::true,
                        needCloseContract        => JSON::XS::true,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    mocked_adfox_user_with_paid_servises => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 7997862,
                        billingContractId        => 237044,
                        hasOtherAccounts         => JSON::XS::false,
                        hasPaidServices          => JSON::XS::true,
                        piAccounts               => [],
                        complexPiLinks           => JSON::XS::false,
                        inWhitelist              => JSON::XS::true,
                        needCloseContract        => JSON::XS::true,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    mocked_adfox_user_with_no_pi_account => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 7997862,
                        billingContractId        => 237044,
                        hasOtherAccounts         => JSON::XS::false,
                        hasPaidServices          => JSON::XS::false,
                        piAccounts               => [],
                        complexPiLinks           => JSON::XS::false,
                        inWhitelist              => JSON::XS::true,
                        needCloseContract        => JSON::XS::true,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    mocked_adfox_user_with_one_pi_account => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 7997862,
                        billingContractId        => 237044,
                        hasOtherAccounts         => JSON::XS::false,
                        hasPaidServices          => JSON::XS::false,
                        piAccounts               => ['traden'],
                        complexPiLinks           => JSON::XS::false,
                        inWhitelist              => JSON::XS::true,
                        needCloseContract        => JSON::XS::true,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    mocked_adfox_user_with_few_pi_account => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 7997862,
                        billingContractId        => 237044,
                        hasOtherAccounts         => JSON::XS::false,
                        hasPaidServices          => JSON::XS::false,
                        piAccounts               => ['traden', 'avonav'],
                        complexPiLinks           => JSON::XS::false,
                        inWhitelist              => JSON::XS::true,
                        needCloseContract        => JSON::XS::true,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    mocked_adfox_user_with_complex_links => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 7997862,
                        billingContractId        => 237044,
                        hasOtherAccounts         => JSON::XS::false,
                        hasPaidServices          => JSON::XS::false,
                        piAccounts               => ['traden'],
                        complexPiLinks           => JSON::XS::true,
                        inWhitelist              => JSON::XS::true,
                        needCloseContract        => JSON::XS::true,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    mocked_adfox_user_with_offer => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 7997862,
                        billingContractId        => 237044,
                        hasOtherAccounts         => JSON::XS::false,
                        hasPaidServices          => JSON::XS::false,
                        piAccounts               => [],
                        complexPiLinks           => JSON::XS::false,
                        inWhitelist              => JSON::XS::true,
                        needCloseContract        => JSON::XS::false,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    mocked_adfox_user_with_offer_without_white_list => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 7997862,
                        billingContractId        => 237044,
                        hasOtherAccounts         => JSON::XS::false,
                        hasPaidServices          => JSON::XS::false,
                        piAccounts               => [],
                        complexPiLinks           => JSON::XS::false,
                        inWhitelist              => JSON::XS::false,
                        needCloseContract        => JSON::XS::false,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    mocked_adfox_user => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 7997862,
                        billingContractId        => 237044,
                        hasOtherAccounts         => JSON::XS::false,
                        hasPaidServices          => JSON::XS::false,
                        piAccounts               => [],
                        complexPiLinks           => JSON::XS::false,
                        inWhitelist              => JSON::XS::true,
                        needCloseContract        => JSON::XS::true,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
    adfox_login_1 => to_json(
        {
            data => {
                AdfoxInternal => {
                    billingClientInfo => {
                        billingClientId          => 7997862,
                        billingContractId        => 237044,
                        hasOtherAccounts         => JSON::XS::false,
                        hasPaidServices          => JSON::XS::false,
                        piAccounts               => [],
                        complexPiLinks           => JSON::XS::false,
                        inWhitelist              => JSON::XS::true,
                        needCloseContract        => JSON::XS::true,
                        userId                   => 0,
                        hasSameUidInOtherAccount => JSON::XS::false,
                    },
                },
            },
        },
    ),
);

run_tests(
    sub {
        my ($app) = @_;

        my $update = need_self_update();
        my $data   = from_json(readfile($path_to_data));

        no strict 'refs';
        no warnings 'redefine';
        local *{'QBit::Application::Model::API::HTTP::call'} = sub {
            my ($self, $path, %opts) = @_;

            my $login = lc(from_json($opts{':content'})->{variables}{adfoxAccount});
            if ($mocked_adfox_users{$login}) {
                return $mocked_adfox_users{$login};
            } else {
                fail('call method');
            }
        };

        my $n = 0;
        foreach my $test (@$data) {
            $n++;
            $test->{name} //= "Test $n";
            subtest(
                $test->{name} => sub {
                    no strict 'refs';
                    no warnings 'redefine';
                    local *{'Application::Model::MailNotification::add_common_offer_error'} = sub {
                        ok($test->{result}{exception}, 'sending e-mail') unless ($update);
                    };
                    local *{'Application::Model::Users::ERROR'} = sub {
                        ok($test->{result}{exception}, 'force error message') unless ($update);
                    };
                    my %origin;
                    foreach my $mock (keys %{$test->{mock}}) {
                        $origin{$mock} = \&$mock;
                        *{$mock} = sub {$test->{mock}{$mock}};
                    }
                    if ($update) {
                        $test->{result} = {};
                        $test->{result}{return} = eval {$app->users->check_pi_adfox_contracts(%{$test->{opts}});};
                        my $err = !$test->{result}{return} && $@;
                        if ($err) {
                            $test->{result}{exception}   = ref $@;
                            $test->{result}{error}       = $@->{text};
                            $test->{result}{error_token} = $@->{error_token};
                        }
                        pass('update');
                    } elsif ($test->{result}{exception}) {
                        throws_ok {
                            $app->users->check_pi_adfox_contracts(%{$test->{opts}});
                        }
                        $test->{result}{exception}, 'catch exception ' . $test->{name};
                        eq_or_diff($@->{text},        $test->{result}{error},       'error message');
                        eq_or_diff($@->{error_token}, $test->{result}{error_token}, 'error token');
                    } else {
                        eq_or_diff(
                            $app->users->check_pi_adfox_contracts(%{$test->{opts}}),
                            $test->{result}{return},
                            'returned value'
                        );
                    }
                    foreach my $mock (keys %{$test->{mock}}) {
                        *{$mock} = $origin{$mock};
                    }
                }
            );
        }
        writefile($path_to_data, to_json($data, pretty => TRUE));
    },
    init => [qw(api_adfox_graphql api_balance documents mail_notification users)],
    user => 'yndx-developer',
);
