#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;

use Test::More;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Differences;

my @ids = (1010, 1015, 1012, 1013, 1014);

run_tests(
    sub {
        my ($app) = @_;

        $app->partner_db->common_offer_allowed_users->add_multi(
            [
                {
                    user_id     => 1015,
                    deadline    => '2018-10-09',
                    accept_date => '2018-10-08 10:00:00',
                },
                {
                    user_id  => 1012,
                    deadline => '2018-10-09',
                },
                {
                    user_id  => 1013,
                    deadline => '2018-10-10',
                },
                {
                    user_id  => 1014,
                    deadline => '2018-10-11',
                },
            ]
        );

        mock_curdate('2018-10-10 15:00:00');

        #Проверка флага has_common_offer
        no strict 'refs';
        no warnings 'redefine';
        *{'Application::Model::SendMail::send'}                           = sub { };
        *{'Application::Model::Users::check_pi_adfox_contracts'}          = sub { };
        *{'Application::Model::API::Yandex::AdFoxGraphQL::create_user'}   = sub { };
        *{'QBit::Application::Model::API::Yandex::Balance::create_offer'} = sub { };
        *{'QBit::Application::Model::API::HTTP::call'}                    = sub { };

        change_cur_user($app, 'tutby-partner');

        $app->common_offer->offer_accept(());

        #id - tutby-partner
        eq_or_diff(
            $app->partner_db->users->get({id => 1024}, fields => [qw(has_common_offer)]),
            {has_common_offer => 1,},
            'check has_common_offer',
        );

        change_cur_user($app, 'yndx-developer');

        my %data;
        for my $id (@ids) {
            $data{$id} = $app->users->get($id, fields => [qw(id login common_offer)]);
        }

        my $has = get_test_data_and_update_if_needed('data.json', \%data);
        eq_or_diff(from_json(to_json(\%data)), $has, 'compare data');
    },
    user => 'yndx-developer',
    init => [qw(api_bk api_balance agreement_checker kv_store users mailer api_adfox_graphql)],

);
