#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;

use Test::More;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Differences;

my @fixtures = ("mocked_yan_partner_games", "mocked_yan_partner");

run_tests(
    \&main_test,
    fill_databases => 0,
    fixtures       => \@fixtures,
);

sub main_test {
    my ($app) = @_;

    mock_curdate('2018-10-10 15:00:00');
    mock_balance($app);

    my @result;
    push @result, make_test($app, 'mocked-yan-partner');
    push @result, make_test($app, 'mocked-yan-partner-games');

    my $has = get_test_data_and_update_if_needed('data.json', \@result);
    eq_or_diff(from_json(to_json(\@result)), $has, 'compare data');
}

sub make_test {
    my ($app, $login) = @_;

    change_cur_user($app, $login);
    my $cu    = $app->get_option('cur_user');
    my $user  = $app->users->_get_object_fields($cu, [qw(id is_games has_game_offer login)]);
    my $check = $app->users->check_game_offer($cu);
    my $accept;
    try {
        $accept = $app->users->accept_game_offer($cu);
    }
    catch {
        my ($e) = @_;
        $accept = 'ERROR: ' . $e->message;
    };
    my $user2 = $app->users->_get_object_fields($cu, [qw(id is_games has_game_offer login)]);
    return {
        name        => $login,
        user_before => $user,
        user_after  => $user2,
        check       => $check,
        accept      => $accept,
    };
}
