#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;

use Test::More;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Differences;

my $xml_multi = '<?xml version="1.0" encoding="UTF-8"?>
<doc>
<user id="120143188">
<uid hosted="0">120143188</uid>
<login>rambler-p</login>
<have_password>1</have_password>
<have_hint>1</have_hint>
<karma confirmed="0">0</karma>
<karma_status>0</karma_status>
<regname>rambler-p</regname>
<display_name>
<name>rambler-p</name>
<avatar>
<default>39460/enc-a32a0f4dc7e3de592c4e49c475b49f5ce33d901f69dcc27a360aedf9cb41be38</default>
<empty>0</empty>
</avatar>
</display_name>
<dbfield id="userinfo.lang.uid">ru</dbfield>
</user>
<user id="184871328">
<uid hosted="0">184871328</uid>
<login>lamoda-tech</login>
<have_password>1</have_password>
<have_hint>1</have_hint>
<karma confirmed="0">0</karma>
<karma_status>0</karma_status>
<regname>lamoda-tech</regname>
<display_name>
<name>lamoda-tech</name>
<avatar>
<default>0/0-0</default>
<empty>1</empty>
</avatar>
</display_name>
<dbfield id="userinfo.lang.uid">ru</dbfield>
</user>
</doc>
';

my $xml_single_no_data = '<?xml version="1.0" encoding="UTF-8"?>
<doc>
<uid hosted="0">184871328</uid>
<login>lamoda-tech</login>
<have_password>1</have_password>
<have_hint>1</have_hint>
<karma confirmed="0">0</karma>
<karma_status>0</karma_status>
<regname>lamoda-tech</regname>
<display_name>
<name>lamoda-tech</name>
<avatar>
<default>0/0-0</default>
<empty>1</empty>
</avatar>
</display_name>
<dbfield id="userinfo.lang.uid">ru</dbfield>
</doc>
';

my $xml_single_with_data = '<?xml version="1.0" encoding="UTF-8"?>
<doc>
<uid hosted="0">120143188</uid>
<login>rambler-p</login>
<have_password>1</have_password>
<have_hint>1</have_hint>
<karma confirmed="0">0</karma>
<karma_status>0</karma_status>
<regname>rambler-p</regname>
<display_name>
<name>rambler-p</name>
<avatar>
<default>39460/enc-a32a0f4dc7e3de592c4e49c475b49f5ce33d901f69dcc27a360aedf9cb41be38</default>
<empty>0</empty>
</avatar>
</display_name>
<dbfield id="userinfo.lang.uid">ru</dbfield>
</doc>
';

my $xml_empty = '<?xml version="1.0" encoding="UTF-8"?>
<doc>
<uid hosted="0"></uid>
<karma confirmed="0">0</karma>
<karma_status>0</karma_status>
</doc>
';

my $xml_error = '<?xml version="1.0" encoding="UTF-8"?>
<doc>
<exception id="2">INVALID_PARAMS</exception>
<error>BlackBox error: invalid uid value. request_id=a881e758d05dfba3. method=userinfo. host=blackbox-mimino.yandex.net. hostname=pass-mimino-s1.sezam.yandex.net. current_time=2020-04-30T09:26:48.484285+0300</error>
</doc>
';

my $XML;

run_tests(
    sub {
        my ($app) = @_;

        mock_subs(
            {
                'QBit::Application::Model::API::HTTP::call' => sub {
                    return $XML;
                  }
            }
        );

        my @data;
        $XML = $xml_single_no_data;
        push @data, ['single login', $app->users->get_by_login('lamoda-tech', fields => [qw(login avatar)])];

        $XML = $xml_single_with_data;
        push @data, ['single login', $app->users->get_by_login('rambler-p', fields => [qw(login avatar)])];

        $XML = $xml_empty;
        push @data, ['unexists uid', $app->api_blackbox->get_users_avatar_and_lang(18487132800)];

        $XML = $xml_error;
        push @data, ['invalid uid', $app->api_blackbox->get_users_avatar_and_lang('aaa')];

        $XML = $xml_multi;
        push @data,
          [
            'multi login',
            $app->users->get_all(filter => {login => ['lamoda-tech', 'rambler-p']}, fields => [qw(login avatar)])
          ];

        my $has = get_test_data_and_update_if_needed('data.json', \@data);
        eq_or_diff(\@data, $has, 'compare data');
    }
);
