#!/usr/bin/perl

use qbit;
use Test::Partner2::Simple;

use Test::More;
use Test::Deep qw(cmp_deeply);

run_tests(
    sub {
        my ($app) = @_;

        cmp_deeply(
            $app->users->get_by_login('lamoda-tech', fields => [qw(login email)],),
            {
                login => 'lamoda-tech',
                email => 'devnull@yandex.ru',
            },
            "users->get_by_login('lamoda-tech')"
        );

        cmp_deeply($app->users->get_by_login('no-such-login', fields => [qw(login email)],),
            undef, "users->get_by_login('no-such-login')");

    }
);
__END__
