#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Exception;
use Test::More;

use Test::Partner2::Mock;
use Test::Partner2::Simple;

my $curdate = curdate(oformat => 'db_time');

run_tests(
    sub {
        my ($app) = @_;

        mock_balance($app);
        mock_blackbox($app);

        my $user_id = $app->cur_user->get_cur_user_id();
        $app->users->edit($user_id, cooperation_form => 'ur');

        is($user_id, 1009, 'expected user_id');

        # feature editable_requisites should be exists
        throws_ok {
            $app->users->do_action($user_id, 'change_contract', type => 'ur');
        }
        'Exception::Multistate::BadAction', 'permissions not enough';
        $app->user_features->add($user_id, 'editable_requisites');

        lives_ok {
            $app->users->do_action($user_id, 'change_contract', type => 'ur');
        }
        'normal call';
    },
    user => 'mocked-yan-partner',
);
