use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

my $USER_ID;
my $APP;

sub _get_email {
    my $data = $APP->users->get($USER_ID, fields => [qw(email)],);

    return $data->{email};
}

run_tests(
    sub {
        ($APP) = @_;

        my $not_valid_email = 'first@example.com; second@example.com';

        $USER_ID = $APP->cur_user->get_cur_user_id();
        is($USER_ID, 1009, 'expected user_id');
        is(_get_email(), 'devnull@yandex.ru', 'original email');

        $APP->users->do_action($USER_ID, 'edit', email => 'new_email@example.com');
        is(_get_email(), 'new_email@example.com', 'changed email');

        eval {$APP->users->do_action($USER_ID, 'edit', email => $not_valid_email);};
        ok($@, 'has error');
        is(_get_email(), 'new_email@example.com', 'email is not changed');

        $APP->partner_db->users->edit($USER_ID, {email => $not_valid_email, name => 'name1'});
        cmp_deeply(
            $APP->users->get($USER_ID, fields => [qw(email name)]),
            {
                email => $not_valid_email,
                name  => 'name1',
            },
            'email is changed to invalid',
        );

        eval {$APP->users->do_action($USER_ID, 'edit', name => 'name2');};
        ok($@, 'has error');
        cmp_deeply(
            $APP->users->get($USER_ID, fields => [qw(email name)]),
            {
                email => $not_valid_email,
                name  => 'name1',
            },
            'email and name is not changed'
        );
    },
    user => 'mocked-yan-partner',
);
