use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_curdate);

use Test::More tests => 9;
use Test::Exception;
use Test::Deep;

use qbit;

use PiConstants qw($SITE_PARTNER_ROLE_ID $VIDEO_PARTNER_ROLE_ID $MOBILE_PARTNER_ROLE_ID $ASSESSOR_ROLE_ID);

run_tests(
    sub {
        my ($app) = @_;
        mock_curdate('2020-09-10 10:10:10');

        my %all_features         = %Application::Model::Users::Features::ALL_FEATURES;
        my @features_auto_assign = grep {exists $all_features{$_}->{auto_assign}} keys %all_features;
        my @features_assessors   = grep {exists $all_features{$_}->{auto_assign_for_assessors}} keys %all_features;

        $app->{'__CURRENT_USER_RIGHTS__'} = {};

        {
            no warnings 'redefine';
            no strict 'refs';

            *{'QBit::Application::Model::SendMail::send'} = sub { };
        }

        my $user = {
            id    => 1009,
            login => 'mocked-yan-partner',
            role  => $SITE_PARTNER_ROLE_ID,
        };
        my $developer = {id => 1022, login => 'yndx-developer'};
        $app->set_cur_user($user);

        cmp_deeply([sort keys %{$app->rbac->get_roles_by_user_id($user->{id})}],
            [$SITE_PARTNER_ROLE_ID], "Checking initial $user->{login} roles");

        throws_ok(
            sub {
                $app->users->do_action($user->{id}, 'edit', roles => [$VIDEO_PARTNER_ROLE_ID, $MOBILE_PARTNER_ROLE_ID]);
            },
            'Exception::Validation::BadArguments',
            "Partner can't edit self roles"
        );

        cmp_deeply(
            $app->users->get($user->{id}, fields => [qw(features)])->{'features'},
            ['design_auction_native', 'mobile_floorad_available', 'simple_inapp', 'turbo_desktop_available'],
            'Check features'
        );

        $app->set_cur_user($developer);
        $app->users->do_action($user->{id}, 'edit', roles => [$VIDEO_PARTNER_ROLE_ID, $MOBILE_PARTNER_ROLE_ID]);
        cmp_deeply(
            [sort keys %{$app->rbac->get_roles_by_user_id($user->{id})}],
            [$VIDEO_PARTNER_ROLE_ID, $MOBILE_PARTNER_ROLE_ID],
            "Checking $user->{login} new roles v1"
        );

        $app->rbac->get_roles_by_user_id($user->{id});
        $app->users->do_action($user->{id}, 'edit', roles => [$SITE_PARTNER_ROLE_ID]);
        cmp_deeply([sort keys %{$app->rbac->get_roles_by_user_id($user->{id})}],
            [$SITE_PARTNER_ROLE_ID], "Checking $user->{login} new roles v2");

        cmp_deeply(
            $app->users->get($user->{id}, fields => [qw(features)])->{'features'},
            [sort (@features_auto_assign, 'turbo_desktop_available')],
            'Check features - not exists context_on_site_natural'
        );

        $app->users->do_action($user->{id}, 'edit', roles => [$ASSESSOR_ROLE_ID]);

        cmp_deeply(
            $app->users->get($user->{id}, fields => [qw(features)])->{'features'},
            [sort (@features_auto_assign, @features_assessors, 'turbo_desktop_available')],
            'Check features - exists context_on_site_natural'
        );
    },
    init  => [qw(mailer)],
    mocks => [qw(mock_format_system)]
);
