#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Differences;
use Test::Exception;
use Test::More tests => 11;

use Exception::Validator::Errors;
use Test::Partner2::Mock;
use Test::Partner2::Simple;

my $curdate       = '2018-08-24 12:00:00';
my $adfox_login   = 'mocked_adfox_login';
my $adfox_user_id = 123456;

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate($curdate);

        my $user_id = $app->cur_user->get_cur_user_id();
        my $model   = $app->users;

        throws_ok {
            $model->do_action($user_id, 'link_adfox_user');
        }
        'Exception::Validation::BadArguments', 'expected exception (not enough params)';
        is($@->message(), 'Not exists next arguments : adfox_id', 'expected exception message (not enough params)');

        lives_ok {
            no warnings 'redefine';
            no strict 'refs';

            local *{'Application::Model::API::Yandex::AdFox::get_adfox_user_info'} = sub {
                my ($self, %opts) = @_;

                eq_or_diff(\%opts, {'adfox_id' => $adfox_user_id,}, 'call get_adfox_user_info');

                return {
                    'id'    => $adfox_user_id,
                    'login' => $adfox_login,
                };
            };
            $model->do_action($user_id, 'link_adfox_user', 'adfox_id' => $adfox_user_id);
        }
        'normal call';

        lives_ok {
            no warnings 'redefine';
            no strict 'refs';

            local *{'Application::Model::API::Yandex::AdFox::get_adfox_user_info'} = sub {
                return {
                    'id'    => $adfox_user_id,
                    'login' => $adfox_login,
                };
            };
            $model->do_action($user_id, 'link_adfox_user', 'adfox_id' => $adfox_user_id);
        }
        'duplicate call';

        my $add = \&QBit::Application::Model::DB::mysql::Table::add;

        lives_ok {
            no warnings 'redefine';
            no strict 'refs';

            local *{'Application::Model::API::Yandex::AdFox::get_adfox_user_info'} = sub {
                fail('call while mobile_mediation');
            };
            local *{'QBit::Application::Model::DB::mysql::Table::add'} = sub {
                # skip for one call (do_action call add to log-table)
                *{'QBit::Application::Model::DB::mysql::Table::add'} = sub {
                    my ($self, @records) = @_;
                    eq_or_diff(
                        \@records,
                        [
                            {
                                'adfox_id'    => $adfox_user_id,
                                'adfox_login' => '',
                                'create_date' => $curdate,
                                'user_id'     => $user_id,
                            }
                        ],
                        'add while mobile_mediation'
                    );
                };
                goto &$add;
            };
            $model->do_action(
                $user_id,
                'link_adfox_user',
                'adfox_id'         => $adfox_user_id,
                'mobile_mediation' => TRUE,
            );
        }
        'mobile_mediation call';

        lives_ok {
            no warnings 'redefine';
            no strict 'refs';

            local *{'QBit::Application::Model::DB::mysql::Table::add'} = sub {
                # skip for one call (do_action call add to log-table)
                *{'QBit::Application::Model::DB::mysql::Table::add'} = sub {
                    my ($self, @records) = @_;
                    eq_or_diff(
                        \@records,
                        [
                            {
                                'adfox_id'    => $adfox_user_id,
                                'adfox_login' => $adfox_login,
                                'create_date' => $curdate,
                                'user_id'     => $user_id,
                            }
                        ],
                        'add while mobile_mediation (with login)'
                    );
                };
                goto &$add;
            };
            $model->do_action(
                $user_id,
                'link_adfox_user',
                'adfox_id'         => $adfox_user_id,
                'adfox_login'      => $adfox_login,
                'mobile_mediation' => TRUE,
            );
        }
        'mobile_mediation call (with login)';
    },
    'init' => [qw( api_adfox )],
    'user' => 'mocked-yan-partner',
);
