#!/usr/bin/perl

use qbit;

use Test::Differences;
use Test::Partner2::Mock;
use Test::Partner2::Simple;

my $USER_ID = 1009;

run_tests(
    sub {
        my ($app) = @_;

        mock_balance($app);

        eq_or_diff(
            $app->users->get($USER_ID, fields => [qw(active_contract)]),
            {
                active_contract => {
                    Contract => {
                        contract_type => 1,
                        contract2_id  => 123456,
                        dt            => '',
                        is_signed     => 1,
                        status        => 'Signed',
                        currency      => 643,
                        firm          => 9,
                        nds           => 1,
                        person_id     => 1,
                    },
                    Person => {
                        bank => {
                            active       => JSON::XS::true,
                            bank_id      => '12345678',
                            bank_id_type => 'bik',
                            name         => 'bank_name',
                        },
                        bik   => '12345678',
                        id    => '666',
                        login => 'mocked-yan-partner',
                    }
                }
            },
            'check active_contract field',
        );
    },
    user => 'yndx-developer',
);
