#!/usr/bin/perl

use qbit;
use PiConstants qw($ASSESSOR_ROLE_ID);

use Test::Partner2::Simple;

use Test::More;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Differences;

my $user_id = 1009;
my $filter  = [AND => [{owner_id => $user_id}, {multistate => 'not (deleted or protected)'}]];
my $fields  = ["page_id", "multistate", "multistate_name"];

run_tests(
    sub {
        my ($app) = @_;

        $app->partner_db->user_role->add(
            {
                user_id => $user_id,
                role_id => $ASSESSOR_ROLE_ID
            }
        );

        my @result;

        push @result, ['init user', $app->users->get($user_id, fields => ['is_assessor', 'roles'])];
        push @result,
          ['init context pages', $app->context_on_site_campaign->get_all(filter => $filter, fields => $fields)];
        push @result,
          ['init search pages', $app->search_on_site_campaign->get_all(filter => $filter, fields => $fields)];

        $app->users->do_action($user_id, 'edit', roles => [9]);

        push @result, ['result user', $app->users->get($user_id, fields => ['is_assessor', 'roles'])];
        push @result,
          [
            'result queue',
            $app->queue->get_all(fields => [qw(user_id method_name params_ref)], filter => {method_type => 9})
          ];
        push @result,
          ['result context pages', $app->context_on_site_campaign->get_all(filter => $filter, fields => $fields)];
        push @result,
          ['init search pages', $app->search_on_site_campaign->get_all(filter => $filter, fields => $fields)];

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(from_json(to_json(\@result)), $has, 'compare data');
    },
    init => [qw(mailer)],
);
