#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;

use Test::Differences;
use Test::Exception;
use Test::More tests => 2 + 4;

my $USER_ID = 1009;

run_tests(
    sub {
        my ($app) = @_;

        eq_or_diff(
            $app->users->get($USER_ID, fields => [qw(inn cooperation_form self_employed self_employed_request_id)]),
            {
                inn                      => undef,
                cooperation_form         => undef,
                self_employed            => undef,
                self_employed_request_id => undef,
            },
            'check initial state',
        );

        $app->users->do_action(
            $USER_ID, 'edit',
            inn              => '1234567890',
            cooperation_form => 'ph',
        );

        eq_or_diff(
            $app->users->get($USER_ID, fields => [qw(inn cooperation_form self_employed self_employed_request_id)]),
            {
                inn                      => '1234567890',
                cooperation_form         => 'ph',
                self_employed            => undef,
                self_employed_request_id => undef,
            },
            'check after edit w/o feature',
        );

        lives_ok {
            $app->users->do_action(
                $USER_ID, 'edit',
                self_employed            => 0,
                self_employed_request_id => '1qaz2wsx',
            );
        }
        'Can edit w feature';

        eq_or_diff(
            $app->users->get($USER_ID, fields => [qw(inn cooperation_form self_employed self_employed_request_id)]),
            {
                inn                      => '1234567890',
                cooperation_form         => 'ph',
                self_employed            => 0,
                self_employed_request_id => '1qaz2wsx',
            },
            'check after edit w feature',
        );
    },
    user => 'yndx-developer',
);
