#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;

use Test::More;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Differences;

my @ids = (1010, 1015, 1012, 1013, 1014);

run_tests(
    sub {
        my ($app) = @_;
        my @result;
        push @result, ['self_features 1',    $app->users->get(88415289, fields => ['features'])];
        push @result, ['partner_features 1', $app->users->get(1024,     fields => ['features'])];

        $app->partner_db->user_features->add_multi(
            [
                {
                    user_id => 88415289,
                    feature => 'context_on_site_natural',
                },
                {
                    user_id => 1024,
                    feature => 'context_on_site_natural',
                }
            ]
        );

        push @result, ['self_features 2',    $app->users->get(88415289, fields => ['features'])];
        push @result, ['partner_features 2', $app->users->get(1024,     fields => ['features'])];

        my $has = get_test_data_and_update_if_needed('data.json', \@result);
        eq_or_diff(\@result, $has, 'compare data');
    },
    user => 'tutby-cop',

);
