#!/usr/bin/perl -w

use Test::Partner::Utils qw(get_bk_data);
use Test::Partner2::Simple;

use Test::More tests => 2 + 1;

use qbit;

my $FEATURE = 'instream_vmap';

run_tests(
    sub {
        my ($app) = @_;

        # Найдём какой-нибудь Рабочий instream-блок
        my $block = $app->video_an_site_instream->get_all(
            fields => [
                qw(
                  id
                  page_id
                  vmap_id
                  )
            ],
            filter => {multistate => 'working',},
            limit  => 1,
        )->[0];
        my $page_id = $block->{page_id};
        my $vmap_id = $block->{vmap_id};

        # Выставим владельцу площадки фичу
        my $owner_id = $app->video_an_site->get($page_id, fields => [qw(owner_id)])->{owner_id};
        $app->user_features->replace_multi($owner_id, [$FEATURE], only_add => TRUE,);

        # Сгенерим bk_data
        # Результат не нужен, просто чтобы в БД поле bk_data заполнилось
        $app->video_an_site_instream->get_bk_data($page_id);

        # Переводим блок в год-мод
        $app->video_an_site_instream->do_action($block, 'edit', is_custom_bk_data => TRUE,);

        # Дублируем сценарий
        my $public_id = $app->video_scenaries->do_action_with_result(
            {
                id      => $vmap_id,
                page_id => $page_id,
            },
            'duplicate'
        )->{public_id};
        my $new_vmap_id = $app->video_scenaries->get($public_id, fields => [qw(id)],)->{id};

        # Найдём блок в год-моде на новом сценарии
        my $new_block = $app->video_an_site_instream->get_all(
            fields => [
                qw(
                  bk_data
                  )
            ],
            filter => {
                is_custom_bk_data => TRUE,
                page_id           => $page_id,
                vmap_id           => $new_vmap_id,
            },
        )->[0];

        # Распакуем bk_data
        my $bk_data = from_json $new_block->{bk_data};

        # Проверим результат
        is($bk_data->{VmapID}, $new_vmap_id, 'check new vmap_id');
    },
);
