#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        {
            no warnings 'redefine', 'once';

            *Application::Model::BKStatistics::is_available = sub {0};
        }

        cmp_deeply(
            $app->widgets->get_widgets(),
            [
                {
                    'first'           => '',
                    'server_settings' => {'message' => re(qr(\w)),},
                    'deletable'       => 1,
                    'type'            => 'welcome',
                    'settings'        => {'role' => 'an_partner'},
                    'accessor'        => 'widget_welcome',
                    'width'           => 'full',
                    'resizable'       => '',
                },
                {
                    'accessor'        => 'widget_adfox',
                    'deletable'       => 1,
                    'first'           => '',
                    'resizable'       => '',
                    'server_settings' => {'message' => re(qr(\w)),},
                    'type'            => 'adfox',
                    'width'           => 'full'
                },
                {
                    'accessor'  => 'widget_statistics',
                    'deletable' => 1,
                    'first'     => '',
                    'resizable' => 1,
                    'settings'  => {
                        'level'     => 'payment',
                        'report_id' => 'context_income_30days',
                        'showType'  => 'chart'
                    },
                    'type'  => 'statistics',
                    'width' => 'full'
                },
                {
                    'accessor'        => 'widget_payment_disclaimer',
                    'deletable'       => 1,
                    'first'           => '',
                    'resizable'       => '',
                    'server_settings' => {'message' => 'payment_disclaimer'},
                    'type'            => 'disclaimer-reward',
                    'width'           => 'full'
                }
            ],
            'get_widgets'
        );

        $app->widgets->do_action($app->get_option('cur_user', {})->{'id'},
            'delete', widgets => {type => 'welcome', accessor => 'widget_welcome', settings => {role => 'an_partner'}});

        cmp_deeply(
            $app->widgets->get_widgets(),
            [
                {
                    'accessor'        => 'widget_adfox',
                    'deletable'       => 1,
                    'first'           => '',
                    'resizable'       => '',
                    'server_settings' => {'message' => re(qr(\w)),},
                    'type'            => 'adfox',
                    'width'           => 'full'
                },
                {
                    'accessor'  => 'widget_statistics',
                    'deletable' => 1,
                    'first'     => '',
                    'resizable' => 1,
                    'settings'  => {
                        'level'     => 'payment',
                        'report_id' => 'context_income_30days',
                        'showType'  => 'chart'
                    },
                    'type'  => 'statistics',
                    'width' => 'full'
                },
                {
                    'accessor'        => 'widget_payment_disclaimer',
                    'deletable'       => 1,
                    'first'           => '',
                    'resizable'       => '',
                    'server_settings' => {'message' => 'payment_disclaimer'},
                    'type'            => 'disclaimer-reward',
                    'width'           => 'full'
                }
            ],
            'get_widgets after do_action($obj, "delete")'
        );
    },
    user                 => 'mocked-context-adblock-partner',
    create_clickhouse_db => TRUE,
    init                 => ['bk_statistics']
);
