#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Partner2::Mock qw(mock_subs);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Differences;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_subs({'Application::Model::BKStatistics::is_available' => sub {1},});

        $app->statistics_reports->add(
            level           => 'payment',
            use_as_widget   => 1,
            caption         => 'caption',
            query           => '{}',
            widget_settings => {showType => 'table'}
        );

        my $got = {};
        $got->{'00 widgets from table'} = $app->partner_db->widgets->get_all(filter => {user_id => 1009});
        $got->{'01 get_widgets BEFORE deleting statistics_reports'} = $app->widgets->get_widgets();

        $app->statistics_reports->do_action(1, 'delete');

        $got->{'02 get_widgets AFTER deleting statistics_reports'} = $app->widgets->get_widgets();

        my $expected = get_test_data_and_update_if_needed('data.json', $got);
        eq_or_diff($got, $expected, 'compare data');
    },
    user => 'mocked-yan-partner',
    init => [qw(bk_statistics)],
);
