#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Differences;
use Test::More;
use Test::Deep;
use Test::Partner2::Mock qw(mock_subs);

use qbit;

my $test_logins = [
    {
        login => 'yndx_developer',
        id    => 1022
    },
    {
        login => 'mocked_yan_partner',
        id    => 1009
    },
    {
        login => 'mocked_dsp_partner',
        id    => 1012
    },
    {
        login => 'mocked_yan_manager',
        id    => 1015
    },
    {
        login => 'mocked_yan_video_partner',
        id    => 1010,
    },
];

run_tests(
    sub {
        my ($app) = @_;

        $app->{'__CURRENT_USER_RIGHTS__'} = {};

        mock_subs({'Application::Model::BKStatistics::is_available' => sub {1},});

        foreach my $login (@$test_logins) {

            my $path_to_data = lib::abs::path("get_widgets/$login->{login}.json");
            my $json_data    = from_json(readfile($path_to_data));

            my $got_data = {};

            $app->set_cur_user({id => $login->{id}});
            my $result = $app->widgets->get_widgets();
            eq_or_diff($json_data, from_json(to_json($result, pretty => TRUE)), "get widgets for $login->{login}");

            # Usage: > ./prove *.t :: --self_update 2>&1 | less
            if (need_self_update()) {
                writefile($path_to_data, to_json($result, pretty => TRUE));
            }
        }
    },
    create_clickhouse_db => TRUE,
    init                 => [qw(bk_statistics)],
);
