#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Differences;
use Test::Partner2::Mock qw(mock_subs);

use PiConstants qw($IS_PRECISE);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_subs({'Application::Model::BKStatistics::is_available' => sub {0},});

        eval {
            $app->widgets->save(
                [
                    {
                        'first'     => '',
                        'deletable' => 1,
                        'type'      => 'welcome',
                        'settings'  => {'role' => 'an_partner'},
                        'accessor'  => 'widget_welcome',
                        'width'     => 'half',
                    }
                ]
            );
        };

        ok($@, 'throw exception');
        is($@->message, 'Width must be "full"', 'Text error');

        $app->widgets->save(
            [
                {
                    'first'     => '',
                    'deletable' => 1,
                    'type'      => 'welcome',
                    'settings'  => {'role' => 'an_partner'},
                    'accessor'  => 'widget_welcome',
                    'width'     => 'full',
                }
            ]
        );

        my $got = {};
        $got->{'00 widgets from table'} = $app->partner_db->widgets->get_all(filter => {user_id => 1009});
        $got->{'01 get_widgets'} = $app->widgets->get_widgets();

        #delete

        $app->widgets->save([]);
        $got->{'02 widgets from table'} = $app->partner_db->widgets->get_all(filter => {user_id => 1009});
        $got->{'03 get_widgets after save([])'} = $app->widgets->get_widgets();

        #check restore

        no warnings 'redefine';
        no strict 'refs';
        *{'Application::Model::Widgets::Widget::Welcome::can_restore'} = sub {TRUE};

        $got->{'04 get_widgets_for_restore'} = $app->widgets->get_widgets_for_restore();

        $app->widgets->save(
            [
                {
                    'first'     => '',
                    'deletable' => 1,
                    'type'      => 'welcome',
                    'settings'  => {'role' => 'an_partner'},
                    'accessor'  => 'widget_welcome',
                    'width'     => 'full',
                }
            ]
        );

        $got->{'05 get_widgets_for_restore empty'} = $app->widgets->get_widgets_for_restore();
        $got->{'05 get_widgets - restore welcome'} = $app->widgets->get_widgets();

        my $expected = get_test_data_and_update_if_needed('data.json', $got);

        if ($IS_PRECISE) {
            $expected->{$_ . ' widgets from table'}[0]{json_default_deleted_ids} =~ s/\"1\"/1/g for (qw/00 02/);
        }
        eq_or_diff($got, $expected, 'compare data', {context => 1});
    },
    user                 => 'mocked-yan-partner',
    locale               => 'C',
    create_clickhouse_db => TRUE,
    init                 => [qw(bk_statistics)],
);
