#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;
use Test::Partner::Utils;

use qbit;

my $assistant_id = 1018;
my $context_id   = 142898;
my $search_id    = 111161;
my $manager_id   = 1015;

run_tests(
    sub {
        my ($app) = @_;

        cmp_deeply(
            $app->users->get_all_assistants(fields => [qw(id login)]),
            [
                {id => $assistant_id, login => 'mocked-yan-partner-assistant'},
                {id => 1036,          login => 'mocked-yan-partner-wo-assistant'}
            ],
            'users->get_all_assisatnts'
        );

        my $cur_user = $app->get_option('cur_user', {});

        #assistant here
        $app->set_cur_user({id => $assistant_id});

        cmp_deeply($app->context_on_site_campaign->get($context_id, fields => ['id']),
            undef, 'context_on_site_campaign->get without assistant');

        cmp_deeply($app->search_on_site_campaign->get($search_id, fields => ['id']),
            undef, 'search_on_site_campaign->get without assistant');

        #partner here
        $app->set_cur_user($cur_user);

        $app->context_on_site_campaign->do_action($context_id, 'edit',
            assistants => [{user_id => $assistant_id, can_edit => 0}]);
        $app->search_on_site_campaign->do_action($search_id, 'edit',
            assistants => [{user_id => $assistant_id, can_edit => 0}]);

        #assistant here
        $app->set_cur_user({id => $assistant_id});

        cmp_deeply(
            $app->context_on_site_campaign->get($context_id, fields => ['id']),
            {id => $context_id},
            'context_on_site_campaign->get with assistant'
        );

        cmp_deeply(
            $app->search_on_site_campaign->get($search_id, fields => ['id']),
            {id => $search_id},
            'search_on_site_campaign->get with assistant'
        );

        is($app->context_on_site_campaign->check_action($context_id, 'edit'), FALSE, 'can not edit context campaign');

        is($app->search_on_site_campaign->check_action($search_id, 'edit'), FALSE, 'can not edit search campaign');

        #partner here
        $app->set_cur_user($cur_user);

        $app->context_on_site_campaign->do_action($context_id, 'edit',
            assistants => [{user_id => $assistant_id, can_edit => 1}]);
        $app->search_on_site_campaign->do_action($search_id, 'edit',
            assistants => [{user_id => $assistant_id, can_edit => 1}]);

        #assistant here
        $app->set_cur_user({id => $assistant_id});

        cmp_deeply(
            $app->context_on_site_campaign->get($context_id, fields => ['id']),
            {id => $context_id},
            'context_on_site_campaign->get with assistant'
        );

        cmp_deeply(
            $app->search_on_site_campaign->get($search_id, fields => ['id']),
            {id => $search_id},
            'search_on_site_campaign->get with assistant'
        );

        is($app->context_on_site_campaign->check_action($context_id, 'edit'), TRUE, 'can edit context campaign');

        is($app->search_on_site_campaign->check_action($search_id, 'edit'), TRUE, 'can edit search campaign');

        #
        #PI-6942
        #

        #manager here
        $app->set_cur_user({id => $manager_id});
        cmp_deeply(
            $app->context_on_site_campaign->get($context_id, fields => ['assistants'])->{'assistants'},
            bag(
                {
                    'can_edit'   => '1',
                    'user_id'    => '1018',
                    'login'      => 'mocked-yan-partner-assistant',
                    'inviter_id' => ''
                }
               ),
            'context_on_site_campaign->get assistants partner'
        );

        #partner here
        $app->set_cur_user($cur_user);

        cmp_deeply(
            $app->context_on_site_campaign->get($context_id, fields => ['assistants'])->{'assistants'},
            [
                {
                    'can_edit'   => '1',
                    'user_id'    => '1018',
                    'login'      => 'mocked-yan-partner-assistant',
                    'inviter_id' => ''
                }
            ],
            'context_on_site_campaign->get assistants partner'
        );

        #
        #end
        #
    },
    user => 'mocked-yan-partner',
);
