#!/usr/bin/perl -w
use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

our $IGNORE_MODELS = {
    models_soap_api => 1,
    all_pages       => 1,
    pagesbs         => 1,
};

our $IGNORE_FIELDS = {
    active       => 1,
    opts         => 1,
    pi_id        => 1,
    create_dt    => 1,
    model        => 1,
    from_trigger => 1,
    unique_id    => 1,
};

our $IGNORE_MODEL_FIELDS = {
    moderation => {'moderation_date' => 1},
    owner_site => {'create_date'     => 1},
    short_link => {'last_call_dt'    => 1},
    internal_context_on_site_rtb => {map {$_ => 1} qw(alt_width alt_height block_type is_mobile_mediation place_id)},
    inviter               => {'lang'         => 1},
    ssp_application       => {'name'         => 1},
    distribution_campaign => {'blocks_limit' => 1, 'blocks_count' => 1},
    context_on_site_rtb => {map {$_ => 1} qw(block_type is_mobile_mediation place_id)},
    mobile_app_rtb      => {
        map {$_ => 1}
          qw(alt_width alt_height ex_direct duplicate_direct site_version media_active media_blocked media_cpm text_active text_blocked text_cpm video_active video_blocked video_cpm)
    },
    context_on_site_content => {
        map {$_ => 1}
          qw(
          alt_height
          alt_width
          alternative_code
          blind
          block_type
          direct_block
          duplicate_direct
          ex_direct
          horizontal_align
          media_active
          media_block
          media_blocked
          media_cpm
          place_id
          show_video
          text_active
          text_blocked
          text_cpm
          video_active
          video_blocked
          video_cpm
          )
    },
    internal_mobile_app_rtb => {
        map {$_ => 1}
          qw(
          adfox_block
          alt_width
          alt_height
          duplicate_direct
          ex_direct
          site_version
          video_active
          video_blocked
          video_cpm
          place_id
          )
    }
};

run_tests(
    sub {
        my ($app) = @_;

        my @models_accessor = grep {!/_action_log$/ && !$IGNORE_MODELS->{$_}} keys(%{$app->get_models()});

        for my $model (grep {$app->$_->can('partner_db_table') && $app->$_->can('get_model_fields')} @models_accessor) {
            my $table = $app->$model->partner_db_table();

            my $db_fields    = $table->fields();
            my $model_fields = $app->$model->get_model_fields();

            my @missing_model_fields =
              map {$_->{name}}
              grep {
                     !$model_fields->{$_->{name}}
                  && !$IGNORE_FIELDS->{$_->{name}}
                  && !$IGNORE_MODEL_FIELDS->{$model}->{$_->{name}}
              } @$db_fields;

            fail("Model $model does'n using following db fields: [" . (join ',', @missing_model_fields) . ']')
              if (@missing_model_fields);
        }
    },
    do_not_die_on_fail => 1,
);
