#!/usr/bin/perl -w
use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

our $IGNORE_MODELS = {models_soap_api => 1,};

our $IGNORE_FIELDS = {};

our $IGNORE_MODEL_FIELDS = {};

run_tests(
    sub {
        my ($app) = @_;

        my @models_accessor = grep {!/_action_log$/ && !$IGNORE_MODELS->{$_}} keys(%{$app->get_models()});

        for my $model (grep {$app->$_->can('partner_db_table') && $app->$_->can('get_model_fields')} @models_accessor) {
            my $table = $app->$model->partner_db_table();

            my $db_fields    = $table->fields();
            my %db_fields    = map {$_->{name} => $_} @$db_fields;
            my $model_fields = $app->$model->get_model_fields();
            my @model_fields = grep {
                     defined($model_fields->{$_}->{db})
                  && !$model_fields->{$_}->{from_opts}
                  && $model_fields->{$_}->{db} eq TRUE
                  && !ref($model_fields->{$_}->{db_expr})
            } keys %$model_fields;

            my @missing_db_fields =
              grep {
                     !$db_fields{$_}
                  && !$IGNORE_FIELDS->{$_}
                  && !$IGNORE_MODEL_FIELDS->{$model}->{$_}
                  && (!$model_fields->{$_}->{db_expr} || !$db_fields{$model_fields->{$_}->{db_expr}})
              } @model_fields;

            fail(   "Table '"
                  . $table->name()
                  . "' does'n contain following fields for model '$model': ["
                  . (join ',', @missing_db_fields) . ']')
              if (@missing_db_fields);
        }
    },
    do_not_die_on_fail => 1,
);
