#!/usr/bin/perl -w
use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Differences qw(eq_or_diff);

use qbit;

our $IGNORE_MODELS = {
    'inviter'                 => 1,
    'mail_notification'       => 1,
    'mobile_app_rtb'          => 1,
    'internal_mobile_app_rtb' => 1,
};

run_tests(
    sub {
        my ($app) = @_;

        my @models_accessor = grep {!/_action_log$/ && !$IGNORE_MODELS->{$_}} keys(%{$app->get_models()});

        my @models_with_schema =
          grep {$app->$_->can('get_opts_schema_name')} @models_accessor;

        my @models_with_opts =
          grep {$app->$_->can('has_opts_storage') && $app->$_->has_opts_storage()} @models_accessor;

        my $diff = arrays_difference(\@models_with_opts, \@models_with_schema);
        fail("Models without schema name: " . join ',', @$diff) if @$diff;

        $diff = arrays_difference(\@models_with_schema, \@models_with_opts);
        fail("Models without opts storage: " . join ',', @$diff) if @$diff;

        my $path = lib::abs::path("../../../../lib/QBit/Validator/Type/JsonSchemas");
        for my $model (@models_with_schema) {
            my $name = $app->$model->get_opts_schema_name();
            my $file = "$path/$name.json";

            my $fields = $app->$model->get_model_fields();
            my @required_fields;
            my @optional_fields;

            for (keys %$fields) {
                if (defined $fields->{$_}->{from_opts}) {
                    if (defined $fields->{$_}->{need_check}->{optional}
                        && $fields->{$_}->{need_check}->{optional})
                    {
                        push @optional_fields, $_;
                    } else {
                        push @required_fields, $_;
                    }
                }
            }

            if (-e $file) {
                my $schema = from_json(readfile($file));

                eq_or_diff(
                    [sort @{$schema->{required}}],
                    [sort @required_fields],
                    "Check required fields in schema for '$model'"
                );
                eq_or_diff(
                    [sort keys %{$schema->{properties}}],
                    [sort @required_fields, @optional_fields],
                    "Check fields in schema for '$model'"
                );

                for (@optional_fields) {
                    ok(
                        ref $schema->{properties}->{$_}->{type} eq 'ARRAY'
                          && in_array('null', $schema->{properties}->{$_}->{type}),
                        "For model '$model' optional field '$_' has` 'null' type"
                      );
                }

            } else {
                fail "Can't find schema $name.json";
            }
        }
    },
    do_not_die_on_fail => 1,
    user               => 'yndx-developer',
);
