#!/usr/bin/perl -w

# Usage:
# > ./prove2 *.t :: --self_update 2>&1 | less
# > SELF_UPDATE=1  ./prove2  $F :: --models context_on_site_campaign,mobile_app_rtb
# > SELF_UPDATE=1  ./prove2  $F :: --pages_only
# > SELF_UPDATE=1  ./prove2  $F :: --blocks_only

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed get_test_data_path);
use Test::Partner2::Utils qw(clean_for_json $SKIP_MODELS);

use Test::More @ARGV ? () : (tests => 222);

use Test::Deep;
use File::Path qw(make_path);

use qbit;

my @users = qw(
  mocked-dsp-manager
  mocked-dsp-partner
  mocked-internal-administrator
  mocked-mobile-app-partner
  mocked-video-partner
  mocked-video-manager
  mocked-yan-manager
  mocked-yan-partner
  mocked-yan-partner-assistant
  yndx-developer
  mocked-context-adblock-partner
  tutby-cop
  );

my @skip_abstract = qw(
  all_pages
  business_blocks
  context_on_site_market
  context_on_site_market_api
  context_on_site_mcb
  context_on_site_mirrors
  context_on_site_stripe
  dsp_documentation
  internal_content
  internal_context_on_site_mirrors
  internal_context_on_site_stripe
  internal_genre
  internal_search_on_site_mirrors
  moderation
  partner_content
  partner_genre
  queue
  search_on_site_market
  search_on_site_market_api
  search_on_site_mcb
  search_on_site_mirrors
  ssp_application
  ssp_context_on_site_campaign_mirrors
  ssp_link_context_rtb
  ssp_link_mobile_app
  ssp_link_video_app
  ssp_mobile_app_settings_mirrors
  ssp_site
  ssp_video_an_site_mirrors
  text_template
  users
  video_an_site_mirrors
  widgets
  );

my %tests = (
    get_db_filter_fields => {
        extra => [qw(blocks pages)],
        skip  => {map {$_ => undef} qw(internal_content)},
        users => ['yndx-developer'],
    },
    get_model_accessors => {
        extra => [qw(blocks pages)],
        skip  => {},
        users => ['yndx-developer'],
    },
    get_model_fields => {
        extra => [],
        skip  => {},
        users => ['yndx-developer'],
    },
    get_need_update_in_bk_fields => {
        extra => [],
        skip  => {},
        users => ['yndx-developer'],
    },
    get_register_rights => {
        extra => [],
        skip  => {},
        users => ['yndx-developer'],
    },
    get_register_right_groups => {
        extra => [],
        skip  => {},
        users => ['yndx-developer'],
    },
    get_db_filter_simple_fields => {
        extra   => [],
        skip    => {},
        users   => \@users,
        cmp_sub => \&cmp_bag,
    },
    get_add_fields => {
        extra => [],
        skip  => {map {$_ => undef} @skip_abstract},
        users => \@users,
    },
    get_block_model_names => {
        extra => [],
        skip  => {},
        users => ['yndx-developer'],
    },
    get_fields_depends => {
        extra => [],
        skip  => {},
        users => ['yndx-developer'],
    },
    get_structure_multistates_graph => {
        extra => [],
        skip  => {},
        users => ['yndx-developer'],
    },
);

run_tests(
    sub {
        my ($app) = @_;

        my $is_check_only_part_of_models = 0;
        my $model_accessors              = [];
        if (grep {$_ eq '--pages_only'} @ARGV) {
            $model_accessors              = $app->product_manager->get_page_model_accessors();
            $is_check_only_part_of_models = 1;
        } elsif (
            grep {
                $_ eq '--blocks_only'
            } @ARGV
          )
        {
            $model_accessors              = $app->product_manager->get_block_model_accessors();
            $is_check_only_part_of_models = 1;
        } elsif (
            grep {
                $_ eq '--models'
            } @ARGV
          )
        {
            my $model = '';
            for my $i (0 .. $#ARGV - 1) {
                if ($ARGV[$i] eq '--models') {
                    $model = $ARGV[$i + 1];
                    last;
                }
            }
            $model_accessors = [split /,/, $model];
            $is_check_only_part_of_models = 1;
        } else {
            $model_accessors = [sort grep {!/_action_log$/} keys(%{$app->get_models()})];
        }

        my %by_login;
        while (my ($method, $opts) = each %tests) {
            my @models =
              grep {$app->$_->can($method)} grep {!exists $opts->{skip}{$_}} (@{$opts->{extra}}, @$model_accessors);

            for my $login (@{$opts->{users}}) {
                $by_login{$login}{$method} = \@models;
            }
        }

        my %data;
        for my $login (keys %by_login) {
            change_cur_user($app, $login);

            if ($login ne 'yndx-developer') {
                my $available_resources =
                  {map {$_->{'resource'} => TRUE} @{$app->resources->get_available_resources()}};

                foreach my $models (values(%{$by_login{$login}})) {
                    $models = [grep {$available_resources->{$_}} @$models];
                }
            }

            for my $method (keys %{$by_login{$login}}) {
                for my $model (@{$by_login{$login}{$method}}) {
                    next if $SKIP_MODELS->{$model};
                    if (my $data = $app->$model->$method) {
                        $data{$model}{$method}{$login} = clean_for_json($data);
                    }
                }
            }
        }

        for my $model (sort keys %data) {
            subtest "check $model" => sub {
                for my $method (sort keys %{$data{$model}}) {
                    my $cmp_sub = $tests{$method}{cmp_sub};
                    for my $login (sort keys %{$data{$model}{$method}}) {
                        my $got_data = $data{$model}{$method}{$login};
                        compare_data($model, $method, $login, $got_data, $cmp_sub);
                    }
                }
            };
        }

        opendir D, get_test_data_path();
        my @extra;
        while (my $f = readdir D) {
            next if $f eq "." || $f eq "..";
            push @extra, $f unless $data{$f};
        }
        closedir D;

        unless ($is_check_only_part_of_models) {
            ok !@extra, ' Extra models path' or ldump(\@extra);
        }
    },
    do_not_die_on_fail   => 1,
    create_clickhouse_db => TRUE,
);

sub compare_data {
    my ($model, $method, $login, $got_data, $cmp_sub) = @_;

    $cmp_sub //= \&cmp_deeply;

    my $json_data = get_test_data_and_update_if_needed("$model/$method/$login.json", $got_data);

    $cmp_sub->($got_data, $json_data, "check $model/$method/$login");
}
