#!/usr/bin/perl -w
use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;
use qbit;

run_tests(
    sub {
        my ($app) = @_;

        for my $page_model (@{$app->product_manager->get_page_model_accessors()}) {

            for my $model (@{$app->$page_model->get_block_model_names}) {
                my $filter = $app->$model->get_multistate_filter_for_update_in_bk();
                ok($filter =~ /not deleted/, "Filter for model '$model' contain 'not deleted' condition");
            }
        }
    },
    do_not_die_on_fail => 1,
);
