#!/usr/bin/perl -w

# Usage: > ./prove2 *.t :: --self_update 2>&1 | less

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Utils qw(   $SKIP_MODELS);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Test::More tests => 76;
use Test::Differences;
use File::Path qw(make_path);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my @models =
          grep {$app->$_->isa('QBit::Application::Model::Multistate')} keys(%{$app->get_models});

        for my $model (@models) {
            next if $SKIP_MODELS->{$model};

            my $m = $app->$model;

            my $graph = $m->get_multistates();
            my $data;
            if ($graph) {
                to_int($_) for values %$graph;

                my @actions = sort keys %{$m->get_registered_actions || {}};
                my $rights = $m->get_registered_actions_rights;

                my $bits = $m->get_multistates_bits_hs;
                my %bits = map {$_ => int $bits->{$_}{bit}} keys %$bits;
                my %opts = map {$_ => $bits->{$_}{opts}} grep {%{$bits->{$_}{opts}}} keys %$bits;

                $data = {
                    actions => \@actions,
                    bits    => \%bits,
                    graph   => $graph,
                    opts    => \%opts,
                    rights  => $rights,
                };
            } else {
                $data = {};
            }
            my $expected = get_test_data_and_update_if_needed("$model.json", $data);
            eq_or_diff($data, $expected, "check $model", {context => 5});
        }
    },
    do_not_die_on_fail   => 1,
    dont_create_database => 1,
);

sub to_int {
    my ($hash) = @_;
    $hash->{$_} = int $hash->{$_} for keys %$hash;
    return $hash;
}
