#!/usr/bin/perl -w

# Usage: > ./prove2 *.t :: --self_update 2>&1 | less

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Utils qw(clean_for_json $SKIP_MODELS);
use Test::Partner2::Mock;

use Test::More tests => 176;

use Test::Differences;
use File::Path qw(make_path);

use qbit;

my @users = qw(
  mocked-dsp-manager
  mocked-dsp-partner
  mocked-internal-administrator
  mocked-mobile-app-partner
  mocked-video-partner
  mocked-video-manager
  mocked-yan-manager
  mocked-yan-partner
  mocked-yan-partner-assistant
  yndx-developer
  mocked-context-adblock-partner
  tutby-partner
  tutby-partner-with-agreement
  tutby-cop
  );

my %skip = map {$_ => TRUE} qw(banks);

my $model;
for my $i (0 .. $#ARGV - 1) {
    if ($ARGV[$i] eq '--model') {
        $model = $ARGV[$i + 1];
        last;
    }
}

my $user;
for my $i (0 .. $#ARGV - 1) {
    if ($ARGV[$i] eq '--user') {
        $user = $ARGV[$i + 1];
        last;
    }
}

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2018-09-07 16:30:04');
        mock_stat($app);

        my @models_accessor =
          grep {!$model or $model eq $_}
          grep {$app->$_->isa('Application::Model::DBManager::Base')}
          grep {!$skip{$_}} keys(%{$app->get_models()});

        my %data;
        for my $login (grep {!$user or $user eq $_} @users) {
            change_cur_user($app, $login);
            for my $model (@models_accessor) {
                next if $SKIP_MODELS->{$model};
                my $fields = $app->$model->_get_fields_obj('*');
                if (my $query = eval {$app->$model->query(fields => $fields)}) {
                    my ($sql, @data) = $query->get_sql_with_data();
                    $data{$model}{$login} = join("\n", $sql, (@data ? ("/*", to_json(\@data), "*/") : ()), '');
                } else {
                    $data{$model}{$login} = ref($@) . "\n";
                }
            }
        }

        for my $model (sort keys %data) {
            subtest "check $model" => sub {
                for my $login (sort keys %{$data{$model}}) {
                    my $got_data = $data{$model}{$login};
                    compare_data($model, $login, $got_data);
                }
            };
        }
    },
    do_not_die_on_fail   => 1,
    create_clickhouse_db => TRUE,
);

sub compare_data {
    my ($model, $login, $got_data) = @_;

    my $path = lib::abs::path("check_query") . "/$model";
    my $file = "$path/$login.sql";

    my $has_data = eval {readfile($file)} // '';

    if (need_self_update()) {
        make_path($path) unless (-e $file);
        writefile($file, $got_data);
        pass("check $model/$login");
    } else {
        eq_or_diff($got_data, $has_data, "check $model/$login");
    }
}

sub mock_stat {
    my ($app) = @_;

    $app->clickhouse_db->statistics->add(
        {
            'all_w_nds'                    => '16513889653200',
            'all_wo_nds'                   => '13994821740000',
            'bad_hits'                     => '1381',
            'bad_shows'                    => '464',
            'bad_win_partner_price_w_nds'  => '47876730000',
            'bad_win_partner_price_wo_nds' => '40573500000',
            'bad_win_price_w_nds'          => '100791588000',
            'bad_win_price_wo_nds'         => '85416600000',
            'block_id'                     => '1',
            'clicks'                       => 0,
            'currency_id'                  => '2',
            'direct_clicks'                => '76',
            'direct_shows'                 => '56877',
            'dsp_id'                       => '1',
            'dt'                           => '2017-07-06',
            'hits'                         => '354884',
            'monetizer_id'                 => 0,
            'page_id'                      => '43569',
            'partner_w_nds'                => '7844248723800',
            'partner_wo_nds'               => '6647668410000',
            'product_id'                   => 'mobile_app_rtb',
            'shows'                        => '102878',
            'tag_id'                       => '0'
        }
    );
}
