SELECT
    `block_tags`.`caption` AS `caption`,
    `block_tags`.`multistate` AS `multistate`,
    `block_tags`.`page_id` AS `page_id`,
    `block_tags`.`public_id` AS `public_id`,
    `block_tags`.`tag_id` AS `tag_id`
FROM `block_tags`
WHERE (
    `block_tags`.`page_id` = ANY (
        SELECT
            `context_on_site_campaign`.`page_id` AS `page_id`
        FROM `context_on_site_campaign`
    )
    OR `block_tags`.`page_id` = ANY (
        SELECT
            `distribution_campaign`.`page_id` AS `page_id`
        FROM `distribution_campaign`
        WHERE (
            `distribution_campaign`.`owner_id` = '1017'
        )
    )
    OR `block_tags`.`page_id` = ANY (
        SELECT
            `indoor`.`page_id` AS `page_id`
        FROM `indoor`
    )
    OR `block_tags`.`page_id` = ANY (
        SELECT
            `internal_context_on_site_campaign`.`id` AS `id`
        FROM `internal_context_on_site_campaign`
        WHERE (
            `internal_context_on_site_campaign`.`id` = ANY (
                SELECT
                    `managers`.`page_id` AS `page_id`
                FROM `managers`
                WHERE (
                    `managers`.`manager_id` = '1017'
                )
            )
        )
    )
    OR `block_tags`.`page_id` = ANY (
        SELECT
            `internal_mobile_app`.`id` AS `id`
        FROM `internal_mobile_app`
        WHERE (
            `internal_mobile_app`.`id` = ANY (
                SELECT
                    `managers`.`page_id` AS `page_id`
                FROM `managers`
                WHERE (
                    `managers`.`manager_id` = '1017'
                )
            )
        )
    )
    OR `block_tags`.`page_id` = ANY (
        SELECT
            `internal_search_on_site_campaign`.`id` AS `id`
        FROM `internal_search_on_site_campaign`
        WHERE (
            `internal_search_on_site_campaign`.`id` = ANY (
                SELECT
                    `managers`.`page_id` AS `page_id`
                FROM `managers`
                WHERE (
                    `managers`.`manager_id` = '1017'
                )
            )
        )
    )
    OR `block_tags`.`page_id` = ANY (
        SELECT
            `mobile_app_settings`.`context_page_id` AS `context_page_id`
        FROM `mobile_app_settings`
    )
    OR `block_tags`.`page_id` = ANY (
        SELECT
            `outdoor`.`page_id` AS `page_id`
        FROM `outdoor`
    )
    OR `block_tags`.`page_id` = ANY (
        SELECT
            `search_on_site_campaign`.`page_id` AS `page_id`
        FROM `search_on_site_campaign`
    )
    OR `block_tags`.`page_id` = ANY (
        SELECT
            `ssp_context_on_site_campaign`.`page_id` AS `page_id`
        FROM `ssp_context_on_site_campaign`
    )
    OR `block_tags`.`page_id` = ANY (
        SELECT
            `ssp_mobile_app_settings`.`page_id` AS `page_id`
        FROM `ssp_mobile_app_settings`
    )
    OR `block_tags`.`page_id` = ANY (
        SELECT
            `ssp_video_an_site`.`page_id` AS `page_id`
        FROM `ssp_video_an_site`
    )
    OR `block_tags`.`page_id` = ANY (
        SELECT
            `video_an_site`.`id` AS `id`
        FROM `video_an_site`
    )
)
