SELECT
    `fast_ban`.`block_id` AS `block_id`,
    `fast_ban`.`create_date` AS `create_date`,
    `fast_ban`.`id` AS `id`,
    `fast_ban`.`model` AS `model`,
    `fast_ban`.`page_id` AS `page_id`,
    `fast_ban`.`id` AS `public_id`,
    `fast_ban`.`url` AS `url`,
    `fast_ban`.`url_md5_hex` AS `url_md5_hex`
FROM `fast_ban`
WHERE (
    (
        `fast_ban`.`model` = 'context_on_site_content'
        AND (`fast_ban`.`page_id`, `fast_ban`.`block_id`) IN (
            SELECT
                `context_on_site_rtb`.`campaign_id` AS `campaign_id`,
                `context_on_site_rtb`.`id` AS `id`
            FROM `context_on_site_rtb`
            WHERE (
                `context_on_site_rtb`.`campaign_id` = ANY (
                    SELECT
                        `context_on_site_campaign`.`page_id` AS `page_id`
                    FROM `context_on_site_campaign`
                    WHERE (
                        `context_on_site_campaign`.`owner_id` = '88415289'
                        OR `context_on_site_campaign`.`owner_id` = ANY (
                            SELECT
                                `users`.`id` AS `id`
                            FROM `users`
                            WHERE (
                                (
                                    (
                                        `users`.`is_tutby` = '1'
                                    )
                                    OR (
                                        `users`.`id` = '88415289'
                                    )
                                )
                                AND (
                                    `users`.`is_tutby` = '1'
                                )
                            )
                        )
                    )
                )
                AND `context_on_site_rtb`.`model` = 'context_on_site_content'
            )
        )
    )
)
