SELECT
    `all_reports`.`data` AS `data`,
    `all_reports`.`from_date` AS `from_date`,
    `all_reports`.`id` AS `id`,
    `all_reports`.`modification_date` AS `modification_date`,
    `all_reports`.`page_id` AS `page_id`,
    `all_reports`.`s3_key` AS `s3_key`,
    `all_reports`.`s3_size` AS `s3_size`,
    `all_reports`.`to_date` AS `to_date`
FROM `video_stat_files` AS `all_reports`
INNER JOIN (
    SELECT
        `video_stat_files`.`from_date` AS `from_date`,
        MAX(`video_stat_files`.`modification_date`) AS `max_md`,
        `video_stat_files`.`page_id` AS `page_id`,
        `video_stat_files`.`to_date` AS `to_date`
    FROM `video_stat_files`
    GROUP BY `page_id`, `from_date`, `to_date`
) `most_recent_reports` ON (
    `all_reports`.`page_id` = `most_recent_reports`.`page_id`
    AND `all_reports`.`from_date` = `most_recent_reports`.`from_date`
    AND `all_reports`.`to_date` = `most_recent_reports`.`to_date`
    AND `most_recent_reports`.`max_md` = `all_reports`.`modification_date`
)
WHERE (
    (
        (
            `all_reports`.`from_date` = '2018-09-06'
            AND `all_reports`.`to_date` = '2018-09-06'
        )
        OR (
            `all_reports`.`from_date` = '2018-09-01'
            AND `all_reports`.`to_date` = '2018-09-06'
        )
        OR (
            `all_reports`.`from_date` < '2018-09-01'
            AND `all_reports`.`from_date` = DATE_FORMAT(`all_reports`.`from_date`, '%Y-%m-01')
            AND `all_reports`.`to_date` = LAST_DAY(`all_reports`.`from_date`)
        )
    )
    AND (
        `all_reports`.`page_id` = ANY (
            SELECT
                `video_an_site`.`id` AS `id`
            FROM `video_an_site`
            WHERE (
                `video_an_site`.`owner_id` = '1018'
                OR `video_an_site`.`id` = ANY (
                    SELECT
                        `assistants`.`page_id` AS `page_id`
                    FROM `assistants`
                    WHERE (
                        `assistants`.`dissabled` = '0'
                        AND `assistants`.`user_id` = '1018'
                    )
                )
            )
        )
    )
)
