#!/usr/bin/perl -w

# Usage: > ./prove2 *.t :: --self_update 2>&1 | less

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Utils qw(clean_for_json $SKIP_MODELS);

use Test::Partner::Utils qw(
  get_bk_data
  get_test_data_and_update_if_needed
  );

use Test::More tests => 13;
use Test::Differences;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $models = $app->product_manager->get_page_model_accessors;

        for my $model (@$models) {
            next if $SKIP_MODELS->{$model};
            subtest "check $model" => sub {
                my $got_data = get_data($app->$model);
                my $has_data = get_test_data_and_update_if_needed("$model.json", $got_data);
                eq_or_diff(from_json(to_json($got_data, pretty => TRUE)), $has_data, "check $model", {context => 5});
            };
        }
    },
    do_not_die_on_fail => 1,
    user               => 'yndx-developer',
);

sub get_data {
    my ($model) = @_;

    my $pk = $model->get_pk_fields;
    my $list = $model->get_all(fields => $pk, filter => {multistate => 'not deleted'});

    sub order {
        my ($elem, $keys) = @_;
        return join ':', map {my $t = $_} @$elem{@$keys}    #extra assign to avoid convertion to string
    }
    $list = [sort {order($a, $pk) cmp order($b, $pk)} @$list];

    my @list;
    for my $row (@$list) {
        my $bk_data;
        eval {$bk_data = get_bk_data($model, $row)};
        if ($@) {
            $bk_data = 'error in get_bk_data';
            warn $model->accessor . "\n" . $@;
        }
        push @list,
          {
            object  => $row,
            bk_data => $bk_data,
          };
    }

    return \@list;
}
