#!/usr/bin/perl -w

# Usage: > ./prove2 *.t :: --self_update 2>&1 | less

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Utils qw(clean_for_json $SKIP_MODELS);
use Test::Partner::Utils qw(
  get_bk_data
  get_test_data_and_update_if_needed
  use_common_blocks_table
  );
use Test::Partner2::Fixture;

use Test::Differences;
use Test::More tests => 13;

use qbit;

my @block_fixtures = (
    'partner_context_rtb_block',
    'partner_context_rtb_vip_block',
    'adinside_context_rtb_block',
    'business_unit_context_rtb_block',
    'internal_context_rtb_block',
    'partner_mobile_native_rtb_block',
    'partner_mobile_native_rtb_block_with_slider',
    'partner_mobile_banner_rtb_block',
    'partner_mobile_interstitial_rtb_block',
    'partner_mobile_rewarded_rtb_block',
    'adinside_mobile_interstitial_rtb_block',
    'business_unit_mobile_interstitial_rtb_block',
    'partner_instream_video_block',
    'partner_instream_video_block_with_max_revenue_strategy',
    'partner_inpage_video_block',
    'partner_fullscreen_video_block',
    'partner_context_rtb_block_with_article',
    'partner_context_rtb_block_with_brands',
    'partner_outdoor_video_block',
    'partner_context_content_block',
    'partner_context_content_block_v2',
    'internal_context_content_block',
    'partner_context_rtb_block_with_show_video_and_pvf',
    'internal_context_rtb_block_pvf',
    'partner_context_rtb_block_with_design_templates',
    'partner_context_natural_block',
    'internal_context_natural_block',
    'partner_instream_video_block_with_jingles',
    'partner_context_rtb_block_with_picategories',
    'partner_context_rtb_block_with_thematics',
    'internal_context_content_block_with_thematics',
    'partner_context_natural_block_with_thematics',
    'internal_context_natural_block_with_thematics',
    'partner_outdoor_video_block_with_thematics',
    'partner_inpage_video_block_with_thematics',
    'partner_fullscreen_video_block_with_thematics',
    'partner_instream_video_block_with_thematics',
    'partner_instream_video_block_with_vpaid_disabled',
    'partner_mobile_banner_rtb_block_with_show_video',
    'internal_context_rtb_block_wuth_only_portal_trusted_banners',
    'partner_context_rtb_block_with_only_portal_trusted_banners',
    'partner_context_rtb_block_with_amp_version',
    'partner_context_rtb_block_with_turbo_version',
    'partner_context_rtb_block_with_turbo_desktop_version',
    'internal_context_rtb_block_with_turbo_version',
    'internal_context_rtb_block_with_turbo_desktop_version',
    'partner_instream_video_block_inroll',
    'partner_instream_video_block_s2sroll',
    'partner_instream_video_block_overlay',
    'partner_outdoor_video_block_with_custom_bk_data',
    'partner_inpage_video_block_w_blocked_videodirect',
    'partner_context_rtb_block_with_video_design',
    'partner_context_rtb_block_with_separate_cpm_strategy',
    'partner_context_rtb_block_with_separate_cpm_strategy_and_video_cpm',
    'partner_context_rtb_block_with_native_design',
    'partner_mobile_adaptive_banner_rtb_block',
    'internal_mobile_adaptive_banner_rtb_block',
    'partner_instream_video_block_vmap',
    'partner_context_content_block_site_version_turbo',
    'partner_context_content_block_site_version_turbo_desktop',
    'internal_context_content_block_site_version_turbo',
    'internal_context_content_block_site_version_turbo_desktop',
    'partner_context_natural_block_site_version_turbo',
    'partner_context_natural_block_site_version_turbo_desktop',
    'internal_context_natural_block_site_version_turbo',
    'internal_context_natural_block_site_version_turbo_desktop',
    'partner_context_rtb_block_with_rewarded',
    'partner_context_rtb_block_with_rewarded_only',
    'partner_context_rtb_block_media_performance_as_text',
    'partner_context_content_block_carousel',
    'internal_context_rtb_block_with_carousel',
    'partner_context_rtb_block_with_geo',
    'partner_instream_video_block_video-non-skippable',
    'partner_mobile_native_rtb_block_with_rich_media_true',
    'partner_mobile_native_rtb_block_with_rich_media_false',
    'partner_mobile_native_rtb_block_with_show_video_true',
    'partner_mobile_native_rtb_block_with_show_video_false',
    'partner_mobile_rewarded_block_simple_inapp',
    'partner_mobile_interstitial_block_simple_inapp',
    'partner_mobile_banner_rtb_block_with_mobile_mediation',
    'partner_mobile_banner_rtb_block_without_mobile_mediation',
    'partner_mobile_native_simple_inapp_rtb_block_with_slider',
    'partner_context_rtb_block_with_unmoderated_dsp',
);

my @page_fixtures = qw(
  partner_outdoor_page_in_testmode
  partner_outdoor_page_with_moderation
  partner_outdoor_page_assessor
  partner_outdoor_page_in_testmode_assessor
  partner_video_page
  partner_video_page_with_direct_vast_request
  partner_mobile_page
  partner_mobile_page_simple_inapp
  );

run_tests(
    sub {
        my ($app) = @_;

        $app->set_cur_user(get_fixture('user_yndx_bessarabov'));

        use_common_blocks_table($app);

        my $models = $app->product_manager->get_page_model_accessors;

        for my $model (@$models) {
            next if $SKIP_MODELS->{$model};

            subtest "check $model" => sub {
                my $got_data = get_data($app->$model);
                my $has_data = get_test_data_and_update_if_needed("$model.json", $got_data);
                eq_or_diff(from_json(to_json($got_data, pretty => TRUE)), $has_data, "check $model", {context => 5});
            };
        }
    },
    do_not_die_on_fail => 1,
    #user               => 'user_yndx_bessarabov',
    fill_databases => 0,
    fixtures       => [
        @block_fixtures, @page_fixtures, 'user_yndx_bessarabov', 'tns_dict_article', 'picategories_dict',
        'feature_vmap_for_mocked_video_partner',
        'feature_simple_inapp_for_mocked_mobile_partner'
    ],
);

sub get_data {
    my ($model) = @_;

    my $pk = $model->get_pk_fields;
    my $list = $model->get_all(fields => $pk, filter => {multistate => 'not deleted'});

    my @list;
    for my $row (@$list) {
        my $bk_data;
        eval {$bk_data = get_bk_data($model, $row)};
        if ($@) {
            $bk_data = 'error in get_bk_data ' . $model->accessor();
            warn $model->accessor . "\n" . $@;
        }
        push @list,
          {
            object  => $row,
            bk_data => $bk_data,
          };
    }

    return \@list;
}
