#!/usr/bin/perl -w

# self update
# SELF_UPDATE=1 ./prove2 ./t/lib/Application/Model/validation_tests.t

# Run one test or some tests in dir
# ./prove2 ./t/lib/Application/Model/validation_tests.t :: ./t/lib/Application/Model/validation_tests/strategy/context_on_site_rtb/tests.json
# ./prove2 ./t/lib/Application/Model/validation_tests.t :: ./t/lib/Application/Model/validation_tests/strategy/context_on_site_rtb/

use qbit;

use File::Find;
use Test::Differences;

use Test::Partner::Utils qw(
  get_test_data_path
  get_test_data_and_update_if_needed
  );

use Test::Partner2::Simple;

my $PATH               = get_test_data_path();
my %VALIDATABLE_MODELS = ();
my $APP;

run_tests(
    sub {
        my ($app) = @_;

        my @paths = @ARGV ? @ARGV : ($PATH);

        $APP = $app;

        %VALIDATABLE_MODELS = map {$_ => TRUE} $APP->qbit_validator_checker->get_model_names_that_use_qbit_validator();

        find(
            {
                wanted   => \&process,
                follow   => 1,
                no_chdir => 1,
            },
            @paths
        );
    },
    do_not_die_on_fail => 1,
    mocked_databases   => 'mocked_databases_restapi',
    mocks              => [qw(mock_format_system mock_blackbox mock_balance)]
);

sub process {
    return if !defined($File::Find::fullname) || $File::Find::fullname !~ /\.json$/;

    my ($path) = $File::Find::fullname =~ /$PATH\/(.+)$/;

    my $tests = get_test_data_and_update_if_needed($path);

    my @results = ();
    foreach my $test (@$tests) {
        my $name = $test->{'name'} || die 'Expected key "name" in test case';

        my $model_name = $test->{'model'} // die 'Expected key "model" in test case';

        my $model = $APP->$model_name;

        my $pk = $test->{'pk'} // die 'Expected key "pk" in test case';

        my $row = $APP->$model_name->get_all(fields => ['*'], filter => $pk)->[0]
          // die sprintf('model: %s, pk: %s not found', $model_name, to_json($pk));

        my $patch = $test->{'patch'} // die 'Expected key "patch" in test case';

        my $row_to_validate = {%$row, %$patch};

        my $qv = QBit::Validator->new(
            data => $row_to_validate,
            app  => $model,
            $model->get_template(),
        );

        my $expected = delete($test->{'result'});

        $test->{'result'} = {
            ok => $qv->has_errors ? JSON::XS::false : JSON::XS::true,
            data => $qv->has_errors
            ? [
                map {_path_to_string($_)}
                sort {join('/', @{$a->{'path'}}) cmp join('/', @{$b->{'path'}})} $qv->get_fields_with_error()
              ]
            : [],
        };

        eq_or_diff($test->{'result'}, $expected, "$path - $name", {context => 1});
    }

    get_test_data_and_update_if_needed($path, $tests);
}

sub _path_to_string {
    my ($error) = @_;

    foreach (@{$error->{'path'}}) {
        $_ .= '';
    }

    return $error;
}
