#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::Deep;
use Test::Partner2::Simple;

use Test::More;
use File::Slurp;

run_tests(
    sub {
        my ($app) = @_;

        my $app_path = sprintf('%s/lib/%s.pm', $app->get_option('ApplicationPath'), 'Application');

        my $app_content = File::Slurp::read_file($app_path, binmode => ':utf8');

        my $stash  = Application::package_stash('Application');
        my $models = $stash->{__MODELS__};

        my $without_accessors = [];
        foreach my $accessor (sort keys %$models) {

            my $ref = ref($app->$accessor);

            my $package_accessor = eval {$app->$accessor->accessor()};
            $package_accessor //= 'UNDEFINED';
            cmp_deeply($package_accessor, $accessor, $ref);
        }

    },
    dont_create_database => 1,
    do_not_die_on_fail   => 1,
);
